package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{SetupHistoryPageToken, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetSetupHistoryRequest(
    resourceName: ResourceName,
    pageToken: Optional[SetupHistoryPageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetSetupHistoryRequest = {
    import GetSetupHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetSetupHistoryRequest
      .builder()
      .resourceName(ResourceName.unwrap(resourceName): java.lang.String)
      .optionallyWith(
        pageToken.map(value =>
          SetupHistoryPageToken.unwrap(value): java.lang.String
        )
      )(_.pageToken)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetSetupHistoryRequest.ReadOnly =
    zio.aws.lightsail.model.GetSetupHistoryRequest.wrap(buildAwsValue())
}
object GetSetupHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetSetupHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetSetupHistoryRequest =
      zio.aws.lightsail.model
        .GetSetupHistoryRequest(resourceName, pageToken.map(value => value))
    def resourceName: ResourceName
    def pageToken: Optional[SetupHistoryPageToken]
    def getResourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(resourceName)
    def getPageToken: ZIO[Any, AwsError, SetupHistoryPageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetSetupHistoryRequest
  ) extends zio.aws.lightsail.model.GetSetupHistoryRequest.ReadOnly {
    override val resourceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.resourceName())
    override val pageToken: Optional[SetupHistoryPageToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pageToken())
        .map(value =>
          zio.aws.lightsail.model.primitives.SetupHistoryPageToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetSetupHistoryRequest
  ): zio.aws.lightsail.model.GetSetupHistoryRequest.ReadOnly = new Wrapper(impl)
}
