package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.SetupHistoryPageToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetSetupHistoryResponse(
    setupHistory: Optional[Iterable[zio.aws.lightsail.model.SetupHistory]] =
      Optional.Absent,
    nextPageToken: Optional[SetupHistoryPageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetSetupHistoryResponse = {
    import GetSetupHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetSetupHistoryResponse
      .builder()
      .optionallyWith(
        setupHistory.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.setupHistory)
      .optionallyWith(
        nextPageToken.map(value =>
          SetupHistoryPageToken.unwrap(value): java.lang.String
        )
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetSetupHistoryResponse.ReadOnly =
    zio.aws.lightsail.model.GetSetupHistoryResponse.wrap(buildAwsValue())
}
object GetSetupHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetSetupHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetSetupHistoryResponse =
      zio.aws.lightsail.model.GetSetupHistoryResponse(
        setupHistory.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def setupHistory
        : Optional[List[zio.aws.lightsail.model.SetupHistory.ReadOnly]]
    def nextPageToken: Optional[SetupHistoryPageToken]
    def getSetupHistory: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.SetupHistory.ReadOnly
    ]] = AwsError.unwrapOptionField("setupHistory", setupHistory)
    def getNextPageToken: ZIO[Any, AwsError, SetupHistoryPageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetSetupHistoryResponse
  ) extends zio.aws.lightsail.model.GetSetupHistoryResponse.ReadOnly {
    override val setupHistory
        : Optional[List[zio.aws.lightsail.model.SetupHistory.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.setupHistory())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.SetupHistory.wrap(item)
          }.toList
        )
    override val nextPageToken: Optional[SetupHistoryPageToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextPageToken())
        .map(value =>
          zio.aws.lightsail.model.primitives.SetupHistoryPageToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetSetupHistoryResponse
  ): zio.aws.lightsail.model.GetSetupHistoryResponse.ReadOnly = new Wrapper(
    impl
  )
}
