package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HeaderObject(
    option: Optional[zio.aws.lightsail.model.ForwardValues] = Optional.Absent,
    headersAllowList: Optional[Iterable[zio.aws.lightsail.model.HeaderEnum]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.HeaderObject = {
    import HeaderObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.HeaderObject
      .builder()
      .optionallyWith(option.map(value => value.unwrap))(_.option)
      .optionallyWith(
        headersAllowList.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.headersAllowListWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.HeaderObject.ReadOnly =
    zio.aws.lightsail.model.HeaderObject.wrap(buildAwsValue())
}
object HeaderObject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.HeaderObject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.HeaderObject =
      zio.aws.lightsail.model.HeaderObject(
        option.map(value => value),
        headersAllowList.map(value => value)
      )
    def option: Optional[zio.aws.lightsail.model.ForwardValues]
    def headersAllowList: Optional[List[zio.aws.lightsail.model.HeaderEnum]]
    def getOption: ZIO[Any, AwsError, zio.aws.lightsail.model.ForwardValues] =
      AwsError.unwrapOptionField("option", option)
    def getHeadersAllowList
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.HeaderEnum]] =
      AwsError.unwrapOptionField("headersAllowList", headersAllowList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.HeaderObject
  ) extends zio.aws.lightsail.model.HeaderObject.ReadOnly {
    override val option: Optional[zio.aws.lightsail.model.ForwardValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.option())
        .map(value => zio.aws.lightsail.model.ForwardValues.wrap(value))
    override val headersAllowList
        : Optional[List[zio.aws.lightsail.model.HeaderEnum]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.headersAllowList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.HeaderEnum.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.HeaderObject
  ): zio.aws.lightsail.model.HeaderObject.ReadOnly = new Wrapper(impl)
}
