package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait HttpTokens {
  def unwrap: software.amazon.awssdk.services.lightsail.model.HttpTokens
}
object HttpTokens {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.HttpTokens
  ): zio.aws.lightsail.model.HttpTokens = value match {
    case software.amazon.awssdk.services.lightsail.model.HttpTokens.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.HttpTokens.OPTIONAL =>
      val r = optional
      r
    case software.amazon.awssdk.services.lightsail.model.HttpTokens.REQUIRED =>
      val r = required
      r
  }
  case object unknownToSdkVersion extends zio.aws.lightsail.model.HttpTokens {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HttpTokens =
      software.amazon.awssdk.services.lightsail.model.HttpTokens.UNKNOWN_TO_SDK_VERSION
  }
  case object optional extends zio.aws.lightsail.model.HttpTokens {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HttpTokens =
      software.amazon.awssdk.services.lightsail.model.HttpTokens.OPTIONAL
  }
  case object required extends zio.aws.lightsail.model.HttpTokens {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HttpTokens =
      software.amazon.awssdk.services.lightsail.model.HttpTokens.REQUIRED
  }
}
