package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceNetworking(
    monthlyTransfer: Optional[zio.aws.lightsail.model.MonthlyTransfer] =
      Optional.Absent,
    ports: Optional[Iterable[zio.aws.lightsail.model.InstancePortInfo]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstanceNetworking = {
    import InstanceNetworking.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceNetworking
      .builder()
      .optionallyWith(monthlyTransfer.map(value => value.buildAwsValue()))(
        _.monthlyTransfer
      )
      .optionallyWith(
        ports.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ports)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.InstanceNetworking.ReadOnly =
    zio.aws.lightsail.model.InstanceNetworking.wrap(buildAwsValue())
}
object InstanceNetworking {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstanceNetworking
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.InstanceNetworking =
      zio.aws.lightsail.model.InstanceNetworking(
        monthlyTransfer.map(value => value.asEditable),
        ports.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def monthlyTransfer
        : Optional[zio.aws.lightsail.model.MonthlyTransfer.ReadOnly]
    def ports: Optional[List[zio.aws.lightsail.model.InstancePortInfo.ReadOnly]]
    def getMonthlyTransfer
        : ZIO[Any, AwsError, zio.aws.lightsail.model.MonthlyTransfer.ReadOnly] =
      AwsError.unwrapOptionField("monthlyTransfer", monthlyTransfer)
    def getPorts: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.InstancePortInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("ports", ports)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceNetworking
  ) extends zio.aws.lightsail.model.InstanceNetworking.ReadOnly {
    override val monthlyTransfer
        : Optional[zio.aws.lightsail.model.MonthlyTransfer.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monthlyTransfer())
        .map(value => zio.aws.lightsail.model.MonthlyTransfer.wrap(value))
    override val ports
        : Optional[List[zio.aws.lightsail.model.InstancePortInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ports())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.InstancePortInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceNetworking
  ): zio.aws.lightsail.model.InstanceNetworking.ReadOnly = new Wrapper(impl)
}
