package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{
  IsoDate,
  NonEmptyString,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class LightsailDistribution(
    name: Optional[ResourceName] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    supportCode: Optional[String] = Optional.Absent,
    createdAt: Optional[IsoDate] = Optional.Absent,
    location: Optional[zio.aws.lightsail.model.ResourceLocation] =
      Optional.Absent,
    resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      Optional.Absent,
    alternativeDomainNames: Optional[Iterable[String]] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    isEnabled: Optional[Boolean] = Optional.Absent,
    domainName: Optional[String] = Optional.Absent,
    bundleId: Optional[String] = Optional.Absent,
    certificateName: Optional[ResourceName] = Optional.Absent,
    origin: Optional[zio.aws.lightsail.model.Origin] = Optional.Absent,
    originPublicDNS: Optional[String] = Optional.Absent,
    defaultCacheBehavior: Optional[zio.aws.lightsail.model.CacheBehavior] =
      Optional.Absent,
    cacheBehaviorSettings: Optional[zio.aws.lightsail.model.CacheSettings] =
      Optional.Absent,
    cacheBehaviors: Optional[
      Iterable[zio.aws.lightsail.model.CacheBehaviorPerPath]
    ] = Optional.Absent,
    ableToUpdateBundle: Optional[Boolean] = Optional.Absent,
    ipAddressType: Optional[zio.aws.lightsail.model.IpAddressType] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.lightsail.model.Tag]] = Optional.Absent,
    viewerMinimumTlsProtocolVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.LightsailDistribution = {
    import LightsailDistribution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LightsailDistribution
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        alternativeDomainNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.alternativeDomainNames)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(isEnabled.map(value => value: java.lang.Boolean))(
        _.isEnabled
      )
      .optionallyWith(domainName.map(value => value: java.lang.String))(
        _.domainName
      )
      .optionallyWith(bundleId.map(value => value: java.lang.String))(
        _.bundleId
      )
      .optionallyWith(
        certificateName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.certificateName)
      .optionallyWith(origin.map(value => value.buildAwsValue()))(_.origin)
      .optionallyWith(originPublicDNS.map(value => value: java.lang.String))(
        _.originPublicDNS
      )
      .optionallyWith(defaultCacheBehavior.map(value => value.buildAwsValue()))(
        _.defaultCacheBehavior
      )
      .optionallyWith(
        cacheBehaviorSettings.map(value => value.buildAwsValue())
      )(_.cacheBehaviorSettings)
      .optionallyWith(
        cacheBehaviors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheBehaviors)
      .optionallyWith(
        ableToUpdateBundle.map(value => value: java.lang.Boolean)
      )(_.ableToUpdateBundle)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        viewerMinimumTlsProtocolVersion.map(value => value: java.lang.String)
      )(_.viewerMinimumTlsProtocolVersion)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.LightsailDistribution.ReadOnly =
    zio.aws.lightsail.model.LightsailDistribution.wrap(buildAwsValue())
}
object LightsailDistribution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.LightsailDistribution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.LightsailDistribution =
      zio.aws.lightsail.model.LightsailDistribution(
        name.map(value => value),
        arn.map(value => value),
        supportCode.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        alternativeDomainNames.map(value => value),
        status.map(value => value),
        isEnabled.map(value => value),
        domainName.map(value => value),
        bundleId.map(value => value),
        certificateName.map(value => value),
        origin.map(value => value.asEditable),
        originPublicDNS.map(value => value),
        defaultCacheBehavior.map(value => value.asEditable),
        cacheBehaviorSettings.map(value => value.asEditable),
        cacheBehaviors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ableToUpdateBundle.map(value => value),
        ipAddressType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        viewerMinimumTlsProtocolVersion.map(value => value)
      )
    def name: Optional[ResourceName]
    def arn: Optional[NonEmptyString]
    def supportCode: Optional[String]
    def createdAt: Optional[IsoDate]
    def location: Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Optional[zio.aws.lightsail.model.ResourceType]
    def alternativeDomainNames: Optional[List[String]]
    def status: Optional[String]
    def isEnabled: Optional[Boolean]
    def domainName: Optional[String]
    def bundleId: Optional[String]
    def certificateName: Optional[ResourceName]
    def origin: Optional[zio.aws.lightsail.model.Origin.ReadOnly]
    def originPublicDNS: Optional[String]
    def defaultCacheBehavior
        : Optional[zio.aws.lightsail.model.CacheBehavior.ReadOnly]
    def cacheBehaviorSettings
        : Optional[zio.aws.lightsail.model.CacheSettings.ReadOnly]
    def cacheBehaviors
        : Optional[List[zio.aws.lightsail.model.CacheBehaviorPerPath.ReadOnly]]
    def ableToUpdateBundle: Optional[Boolean]
    def ipAddressType: Optional[zio.aws.lightsail.model.IpAddressType]
    def tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def viewerMinimumTlsProtocolVersion: Optional[String]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getAlternativeDomainNames: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("alternativeDomainNames", alternativeDomainNames)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getIsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isEnabled", isEnabled)
    def getDomainName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getBundleId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bundleId", bundleId)
    def getCertificateName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("certificateName", certificateName)
    def getOrigin: ZIO[Any, AwsError, zio.aws.lightsail.model.Origin.ReadOnly] =
      AwsError.unwrapOptionField("origin", origin)
    def getOriginPublicDNS: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("originPublicDNS", originPublicDNS)
    def getDefaultCacheBehavior
        : ZIO[Any, AwsError, zio.aws.lightsail.model.CacheBehavior.ReadOnly] =
      AwsError.unwrapOptionField("defaultCacheBehavior", defaultCacheBehavior)
    def getCacheBehaviorSettings
        : ZIO[Any, AwsError, zio.aws.lightsail.model.CacheSettings.ReadOnly] =
      AwsError.unwrapOptionField("cacheBehaviorSettings", cacheBehaviorSettings)
    def getCacheBehaviors: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.CacheBehaviorPerPath.ReadOnly
    ]] = AwsError.unwrapOptionField("cacheBehaviors", cacheBehaviors)
    def getAbleToUpdateBundle: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ableToUpdateBundle", ableToUpdateBundle)
    def getIpAddressType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.IpAddressType] =
      AwsError.unwrapOptionField("ipAddressType", ipAddressType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getViewerMinimumTlsProtocolVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "viewerMinimumTlsProtocolVersion",
        viewerMinimumTlsProtocolVersion
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.LightsailDistribution
  ) extends zio.aws.lightsail.model.LightsailDistribution.ReadOnly {
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val supportCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.supportCode())
      .map(value => value: String)
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val alternativeDomainNames: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alternativeDomainNames())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val isEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isEnabled())
      .map(value => value: Boolean)
    override val domainName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => value: String)
    override val bundleId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bundleId())
      .map(value => value: String)
    override val certificateName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val origin: Optional[zio.aws.lightsail.model.Origin.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.origin())
        .map(value => zio.aws.lightsail.model.Origin.wrap(value))
    override val originPublicDNS: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.originPublicDNS())
      .map(value => value: String)
    override val defaultCacheBehavior
        : Optional[zio.aws.lightsail.model.CacheBehavior.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultCacheBehavior())
        .map(value => zio.aws.lightsail.model.CacheBehavior.wrap(value))
    override val cacheBehaviorSettings
        : Optional[zio.aws.lightsail.model.CacheSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheBehaviorSettings())
        .map(value => zio.aws.lightsail.model.CacheSettings.wrap(value))
    override val cacheBehaviors: Optional[
      List[zio.aws.lightsail.model.CacheBehaviorPerPath.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheBehaviors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.CacheBehaviorPerPath.wrap(item)
        }.toList
      )
    override val ableToUpdateBundle: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ableToUpdateBundle())
      .map(value => value: Boolean)
    override val ipAddressType
        : Optional[zio.aws.lightsail.model.IpAddressType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipAddressType())
        .map(value => zio.aws.lightsail.model.IpAddressType.wrap(value))
    override val tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val viewerMinimumTlsProtocolVersion: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.viewerMinimumTlsProtocolVersion())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.LightsailDistribution
  ): zio.aws.lightsail.model.LightsailDistribution.ReadOnly = new Wrapper(impl)
}
