package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{Integer, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Origin(
    name: Optional[ResourceName] = Optional.Absent,
    resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      Optional.Absent,
    regionName: Optional[zio.aws.lightsail.model.RegionName] = Optional.Absent,
    protocolPolicy: Optional[zio.aws.lightsail.model.OriginProtocolPolicyEnum] =
      Optional.Absent,
    responseTimeout: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Origin = {
    import Origin.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Origin
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(regionName.map(value => value.unwrap))(_.regionName)
      .optionallyWith(protocolPolicy.map(value => value.unwrap))(
        _.protocolPolicy
      )
      .optionallyWith(responseTimeout.map(value => value: java.lang.Integer))(
        _.responseTimeout
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.Origin.ReadOnly =
    zio.aws.lightsail.model.Origin.wrap(buildAwsValue())
}
object Origin {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.Origin] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.Origin =
      zio.aws.lightsail.model.Origin(
        name.map(value => value),
        resourceType.map(value => value),
        regionName.map(value => value),
        protocolPolicy.map(value => value),
        responseTimeout.map(value => value)
      )
    def name: Optional[ResourceName]
    def resourceType: Optional[zio.aws.lightsail.model.ResourceType]
    def regionName: Optional[zio.aws.lightsail.model.RegionName]
    def protocolPolicy
        : Optional[zio.aws.lightsail.model.OriginProtocolPolicyEnum]
    def responseTimeout: Optional[Integer]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getRegionName: ZIO[Any, AwsError, zio.aws.lightsail.model.RegionName] =
      AwsError.unwrapOptionField("regionName", regionName)
    def getProtocolPolicy
        : ZIO[Any, AwsError, zio.aws.lightsail.model.OriginProtocolPolicyEnum] =
      AwsError.unwrapOptionField("protocolPolicy", protocolPolicy)
    def getResponseTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("responseTimeout", responseTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Origin
  ) extends zio.aws.lightsail.model.Origin.ReadOnly {
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val regionName: Optional[zio.aws.lightsail.model.RegionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regionName())
        .map(value => zio.aws.lightsail.model.RegionName.wrap(value))
    override val protocolPolicy
        : Optional[zio.aws.lightsail.model.OriginProtocolPolicyEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocolPolicy())
        .map(value =>
          zio.aws.lightsail.model.OriginProtocolPolicyEnum.wrap(value)
        )
    override val responseTimeout: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.responseTimeout())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Origin
  ): zio.aws.lightsail.model.Origin.ReadOnly = new Wrapper(impl)
}
