package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait PricingUnit {
  def unwrap: software.amazon.awssdk.services.lightsail.model.PricingUnit
}
object PricingUnit {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.PricingUnit
  ): zio.aws.lightsail.model.PricingUnit = value match {
    case software.amazon.awssdk.services.lightsail.model.PricingUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.PricingUnit.GB =>
      val r = GB
      r
    case software.amazon.awssdk.services.lightsail.model.PricingUnit.HRS =>
      val r = Hrs
      r
    case software.amazon.awssdk.services.lightsail.model.PricingUnit.GB_MO =>
      val r = `GB-Mo`
      r
    case software.amazon.awssdk.services.lightsail.model.PricingUnit.BUNDLES =>
      val r = Bundles
      r
    case software.amazon.awssdk.services.lightsail.model.PricingUnit.QUERIES =>
      val r = Queries
      r
  }
  case object unknownToSdkVersion extends zio.aws.lightsail.model.PricingUnit {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.PricingUnit =
      software.amazon.awssdk.services.lightsail.model.PricingUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object GB extends zio.aws.lightsail.model.PricingUnit {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.PricingUnit =
      software.amazon.awssdk.services.lightsail.model.PricingUnit.GB
  }
  case object Hrs extends zio.aws.lightsail.model.PricingUnit {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.PricingUnit =
      software.amazon.awssdk.services.lightsail.model.PricingUnit.HRS
  }
  case object `GB-Mo` extends zio.aws.lightsail.model.PricingUnit {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.PricingUnit =
      software.amazon.awssdk.services.lightsail.model.PricingUnit.GB_MO
  }
  case object Bundles extends zio.aws.lightsail.model.PricingUnit {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.PricingUnit =
      software.amazon.awssdk.services.lightsail.model.PricingUnit.BUNDLES
  }
  case object Queries extends zio.aws.lightsail.model.PricingUnit {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.PricingUnit =
      software.amazon.awssdk.services.lightsail.model.PricingUnit.QUERIES
  }
}
