package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class R53HostedZoneDeletionState(
    code: Optional[zio.aws.lightsail.model.R53HostedZoneDeletionStateCode] =
      Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.R53HostedZoneDeletionState = {
    import R53HostedZoneDeletionState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.R53HostedZoneDeletionState
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.R53HostedZoneDeletionState.ReadOnly =
    zio.aws.lightsail.model.R53HostedZoneDeletionState.wrap(buildAwsValue())
}
object R53HostedZoneDeletionState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.R53HostedZoneDeletionState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.R53HostedZoneDeletionState =
      zio.aws.lightsail.model.R53HostedZoneDeletionState(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Optional[zio.aws.lightsail.model.R53HostedZoneDeletionStateCode]
    def message: Optional[String]
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.R53HostedZoneDeletionStateCode
    ] = AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.R53HostedZoneDeletionState
  ) extends zio.aws.lightsail.model.R53HostedZoneDeletionState.ReadOnly {
    override val code
        : Optional[zio.aws.lightsail.model.R53HostedZoneDeletionStateCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value =>
          zio.aws.lightsail.model.R53HostedZoneDeletionStateCode.wrap(value)
        )
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.R53HostedZoneDeletionState
  ): zio.aws.lightsail.model.R53HostedZoneDeletionState.ReadOnly = new Wrapper(
    impl
  )
}
