package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RebootInstanceRequest(instanceName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest = {
    import RebootInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest
      .builder()
      .instanceName(ResourceName.unwrap(instanceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.RebootInstanceRequest.ReadOnly =
    zio.aws.lightsail.model.RebootInstanceRequest.wrap(buildAwsValue())
}
object RebootInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.RebootInstanceRequest =
      zio.aws.lightsail.model.RebootInstanceRequest(instanceName)
    def instanceName: ResourceName
    def getInstanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest
  ) extends zio.aws.lightsail.model.RebootInstanceRequest.ReadOnly {
    override val instanceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.instanceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest
  ): zio.aws.lightsail.model.RebootInstanceRequest.ReadOnly = new Wrapper(impl)
}
