package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisteredDomainDelegationInfo(
    nameServersUpdateState: Optional[
      zio.aws.lightsail.model.NameServersUpdateState
    ] = Optional.Absent,
    r53HostedZoneDeletionState: Optional[
      zio.aws.lightsail.model.R53HostedZoneDeletionState
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RegisteredDomainDelegationInfo = {
    import RegisteredDomainDelegationInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RegisteredDomainDelegationInfo
      .builder()
      .optionallyWith(
        nameServersUpdateState.map(value => value.buildAwsValue())
      )(_.nameServersUpdateState)
      .optionallyWith(
        r53HostedZoneDeletionState.map(value => value.buildAwsValue())
      )(_.r53HostedZoneDeletionState)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.RegisteredDomainDelegationInfo.ReadOnly =
    zio.aws.lightsail.model.RegisteredDomainDelegationInfo.wrap(buildAwsValue())
}
object RegisteredDomainDelegationInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RegisteredDomainDelegationInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.RegisteredDomainDelegationInfo =
      zio.aws.lightsail.model.RegisteredDomainDelegationInfo(
        nameServersUpdateState.map(value => value.asEditable),
        r53HostedZoneDeletionState.map(value => value.asEditable)
      )
    def nameServersUpdateState
        : Optional[zio.aws.lightsail.model.NameServersUpdateState.ReadOnly]
    def r53HostedZoneDeletionState
        : Optional[zio.aws.lightsail.model.R53HostedZoneDeletionState.ReadOnly]
    def getNameServersUpdateState: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.NameServersUpdateState.ReadOnly
    ] = AwsError.unwrapOptionField(
      "nameServersUpdateState",
      nameServersUpdateState
    )
    def getR53HostedZoneDeletionState: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.R53HostedZoneDeletionState.ReadOnly
    ] = AwsError.unwrapOptionField(
      "r53HostedZoneDeletionState",
      r53HostedZoneDeletionState
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RegisteredDomainDelegationInfo
  ) extends zio.aws.lightsail.model.RegisteredDomainDelegationInfo.ReadOnly {
    override val nameServersUpdateState
        : Optional[zio.aws.lightsail.model.NameServersUpdateState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nameServersUpdateState())
        .map(value =>
          zio.aws.lightsail.model.NameServersUpdateState.wrap(value)
        )
    override val r53HostedZoneDeletionState: Optional[
      zio.aws.lightsail.model.R53HostedZoneDeletionState.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.r53HostedZoneDeletionState())
      .map(value =>
        zio.aws.lightsail.model.R53HostedZoneDeletionState.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RegisteredDomainDelegationInfo
  ): zio.aws.lightsail.model.RegisteredDomainDelegationInfo.ReadOnly =
    new Wrapper(impl)
}
