package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{IsoDate, ResourceName}
import scala.jdk.CollectionConverters._
final case class ResourceBudgetEstimate(
    resourceName: Optional[ResourceName] = Optional.Absent,
    resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      Optional.Absent,
    costEstimates: Optional[Iterable[zio.aws.lightsail.model.CostEstimate]] =
      Optional.Absent,
    startTime: Optional[IsoDate] = Optional.Absent,
    endTime: Optional[IsoDate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ResourceBudgetEstimate = {
    import ResourceBudgetEstimate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ResourceBudgetEstimate
      .builder()
      .optionallyWith(
        resourceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.resourceName)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        costEstimates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.costEstimates)
      .optionallyWith(startTime.map(value => IsoDate.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => IsoDate.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.ResourceBudgetEstimate.ReadOnly =
    zio.aws.lightsail.model.ResourceBudgetEstimate.wrap(buildAwsValue())
}
object ResourceBudgetEstimate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ResourceBudgetEstimate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ResourceBudgetEstimate =
      zio.aws.lightsail.model.ResourceBudgetEstimate(
        resourceName.map(value => value),
        resourceType.map(value => value),
        costEstimates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        startTime.map(value => value),
        endTime.map(value => value)
      )
    def resourceName: Optional[ResourceName]
    def resourceType: Optional[zio.aws.lightsail.model.ResourceType]
    def costEstimates
        : Optional[List[zio.aws.lightsail.model.CostEstimate.ReadOnly]]
    def startTime: Optional[IsoDate]
    def endTime: Optional[IsoDate]
    def getResourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getCostEstimates: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.CostEstimate.ReadOnly
    ]] = AwsError.unwrapOptionField("costEstimates", costEstimates)
    def getStartTime: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ResourceBudgetEstimate
  ) extends zio.aws.lightsail.model.ResourceBudgetEstimate.ReadOnly {
    override val resourceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val costEstimates
        : Optional[List[zio.aws.lightsail.model.CostEstimate.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.costEstimates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.CostEstimate.wrap(item)
          }.toList
        )
    override val startTime: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val endTime: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ResourceBudgetEstimate
  ): zio.aws.lightsail.model.ResourceBudgetEstimate.ReadOnly = new Wrapper(impl)
}
