package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  SensitiveNonEmptyString,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Session(
    name: Optional[NonEmptyString] = Optional.Absent,
    url: Optional[SensitiveNonEmptyString] = Optional.Absent,
    isPrimary: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Session = {
    import Session.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Session
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        url.map(value =>
          SensitiveNonEmptyString.unwrap(value): java.lang.String
        )
      )(_.url)
      .optionallyWith(isPrimary.map(value => value: java.lang.Boolean))(
        _.isPrimary
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.Session.ReadOnly =
    zio.aws.lightsail.model.Session.wrap(buildAwsValue())
}
object Session {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.Session] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.Session =
      zio.aws.lightsail.model.Session(
        name.map(value => value),
        url.map(value => value),
        isPrimary.map(value => value)
      )
    def name: Optional[NonEmptyString]
    def url: Optional[SensitiveNonEmptyString]
    def isPrimary: Optional[Boolean]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getUrl: ZIO[Any, AwsError, SensitiveNonEmptyString] =
      AwsError.unwrapOptionField("url", url)
    def getIsPrimary: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isPrimary", isPrimary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Session
  ) extends zio.aws.lightsail.model.Session.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val url: Optional[SensitiveNonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value =>
        zio.aws.lightsail.model.primitives.SensitiveNonEmptyString(value)
      )
    override val isPrimary: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isPrimary())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Session
  ): zio.aws.lightsail.model.Session.ReadOnly = new Wrapper(impl)
}
