package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SetIpAddressTypeRequest(
    resourceType: zio.aws.lightsail.model.ResourceType,
    resourceName: ResourceName,
    ipAddressType: zio.aws.lightsail.model.IpAddressType,
    acceptBundleUpdate: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeRequest = {
    import SetIpAddressTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeRequest
      .builder()
      .resourceType(resourceType.unwrap)
      .resourceName(ResourceName.unwrap(resourceName): java.lang.String)
      .ipAddressType(ipAddressType.unwrap)
      .optionallyWith(
        acceptBundleUpdate.map(value => value: java.lang.Boolean)
      )(_.acceptBundleUpdate)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.SetIpAddressTypeRequest.ReadOnly =
    zio.aws.lightsail.model.SetIpAddressTypeRequest.wrap(buildAwsValue())
}
object SetIpAddressTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.SetIpAddressTypeRequest =
      zio.aws.lightsail.model.SetIpAddressTypeRequest(
        resourceType,
        resourceName,
        ipAddressType,
        acceptBundleUpdate.map(value => value)
      )
    def resourceType: zio.aws.lightsail.model.ResourceType
    def resourceName: ResourceName
    def ipAddressType: zio.aws.lightsail.model.IpAddressType
    def acceptBundleUpdate: Optional[Boolean]
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.lightsail.model.ResourceType] =
      ZIO.succeed(resourceType)
    def getResourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(resourceName)
    def getIpAddressType
        : ZIO[Any, Nothing, zio.aws.lightsail.model.IpAddressType] =
      ZIO.succeed(ipAddressType)
    def getAcceptBundleUpdate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("acceptBundleUpdate", acceptBundleUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeRequest
  ) extends zio.aws.lightsail.model.SetIpAddressTypeRequest.ReadOnly {
    override val resourceType: zio.aws.lightsail.model.ResourceType =
      zio.aws.lightsail.model.ResourceType.wrap(impl.resourceType())
    override val resourceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.resourceName())
    override val ipAddressType: zio.aws.lightsail.model.IpAddressType =
      zio.aws.lightsail.model.IpAddressType.wrap(impl.ipAddressType())
    override val acceptBundleUpdate: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.acceptBundleUpdate())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeRequest
  ): zio.aws.lightsail.model.SetIpAddressTypeRequest.ReadOnly = new Wrapper(
    impl
  )
}
