package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{NonEmptyString, IsoDate}
import scala.jdk.CollectionConverters._
final case class SetupExecutionDetails(
    command: Optional[String] = Optional.Absent,
    dateTime: Optional[IsoDate] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[zio.aws.lightsail.model.SetupStatus] = Optional.Absent,
    standardError: Optional[String] = Optional.Absent,
    standardOutput: Optional[String] = Optional.Absent,
    version: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.SetupExecutionDetails = {
    import SetupExecutionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.SetupExecutionDetails
      .builder()
      .optionallyWith(command.map(value => value: java.lang.String))(_.command)
      .optionallyWith(dateTime.map(value => IsoDate.unwrap(value): Instant))(
        _.dateTime
      )
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(standardError.map(value => value: java.lang.String))(
        _.standardError
      )
      .optionallyWith(standardOutput.map(value => value: java.lang.String))(
        _.standardOutput
      )
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.SetupExecutionDetails.ReadOnly =
    zio.aws.lightsail.model.SetupExecutionDetails.wrap(buildAwsValue())
}
object SetupExecutionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.SetupExecutionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.SetupExecutionDetails =
      zio.aws.lightsail.model.SetupExecutionDetails(
        command.map(value => value),
        dateTime.map(value => value),
        name.map(value => value),
        status.map(value => value),
        standardError.map(value => value),
        standardOutput.map(value => value),
        version.map(value => value)
      )
    def command: Optional[String]
    def dateTime: Optional[IsoDate]
    def name: Optional[NonEmptyString]
    def status: Optional[zio.aws.lightsail.model.SetupStatus]
    def standardError: Optional[String]
    def standardOutput: Optional[String]
    def version: Optional[String]
    def getCommand: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("command", command)
    def getDateTime: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("dateTime", dateTime)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, zio.aws.lightsail.model.SetupStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStandardError: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("standardError", standardError)
    def getStandardOutput: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("standardOutput", standardOutput)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.SetupExecutionDetails
  ) extends zio.aws.lightsail.model.SetupExecutionDetails.ReadOnly {
    override val command: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.command())
      .map(value => value: String)
    override val dateTime: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.dateTime())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val status: Optional[zio.aws.lightsail.model.SetupStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.lightsail.model.SetupStatus.wrap(value))
    override val standardError: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.standardError())
      .map(value => value: String)
    override val standardOutput: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.standardOutput())
      .map(value => value: String)
    override val version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.SetupExecutionDetails
  ): zio.aws.lightsail.model.SetupExecutionDetails.ReadOnly = new Wrapper(impl)
}
