package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SetupHistory(
    operationId: Optional[NonEmptyString] = Optional.Absent,
    request: Optional[zio.aws.lightsail.model.SetupRequest] = Optional.Absent,
    resource: Optional[zio.aws.lightsail.model.SetupHistoryResource] =
      Optional.Absent,
    executionDetails: Optional[
      Iterable[zio.aws.lightsail.model.SetupExecutionDetails]
    ] = Optional.Absent,
    status: Optional[zio.aws.lightsail.model.SetupStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.SetupHistory = {
    import SetupHistory.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.SetupHistory
      .builder()
      .optionallyWith(
        operationId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.operationId)
      .optionallyWith(request.map(value => value.buildAwsValue()))(_.request)
      .optionallyWith(resource.map(value => value.buildAwsValue()))(_.resource)
      .optionallyWith(
        executionDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.executionDetails)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.SetupHistory.ReadOnly =
    zio.aws.lightsail.model.SetupHistory.wrap(buildAwsValue())
}
object SetupHistory {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.SetupHistory
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.SetupHistory =
      zio.aws.lightsail.model.SetupHistory(
        operationId.map(value => value),
        request.map(value => value.asEditable),
        resource.map(value => value.asEditable),
        executionDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value)
      )
    def operationId: Optional[NonEmptyString]
    def request: Optional[zio.aws.lightsail.model.SetupRequest.ReadOnly]
    def resource
        : Optional[zio.aws.lightsail.model.SetupHistoryResource.ReadOnly]
    def executionDetails
        : Optional[List[zio.aws.lightsail.model.SetupExecutionDetails.ReadOnly]]
    def status: Optional[zio.aws.lightsail.model.SetupStatus]
    def getOperationId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("operationId", operationId)
    def getRequest
        : ZIO[Any, AwsError, zio.aws.lightsail.model.SetupRequest.ReadOnly] =
      AwsError.unwrapOptionField("request", request)
    def getResource: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.SetupHistoryResource.ReadOnly
    ] = AwsError.unwrapOptionField("resource", resource)
    def getExecutionDetails: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.SetupExecutionDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("executionDetails", executionDetails)
    def getStatus: ZIO[Any, AwsError, zio.aws.lightsail.model.SetupStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.SetupHistory
  ) extends zio.aws.lightsail.model.SetupHistory.ReadOnly {
    override val operationId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.operationId())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val request
        : Optional[zio.aws.lightsail.model.SetupRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.request())
        .map(value => zio.aws.lightsail.model.SetupRequest.wrap(value))
    override val resource
        : Optional[zio.aws.lightsail.model.SetupHistoryResource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resource())
        .map(value => zio.aws.lightsail.model.SetupHistoryResource.wrap(value))
    override val executionDetails: Optional[
      List[zio.aws.lightsail.model.SetupExecutionDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.executionDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.SetupExecutionDetails.wrap(item)
        }.toList
      )
    override val status: Optional[zio.aws.lightsail.model.SetupStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.lightsail.model.SetupStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.SetupHistory
  ): zio.aws.lightsail.model.SetupHistory.ReadOnly = new Wrapper(impl)
}
