package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  SetupDomainName,
  EmailAddress,
  ResourceName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SetupInstanceHttpsRequest(
    instanceName: ResourceName,
    emailAddress: EmailAddress,
    domainNames: Iterable[SetupDomainName],
    certificateProvider: zio.aws.lightsail.model.CertificateProvider
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.SetupInstanceHttpsRequest = {
    import SetupInstanceHttpsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.SetupInstanceHttpsRequest
      .builder()
      .instanceName(ResourceName.unwrap(instanceName): java.lang.String)
      .emailAddress(EmailAddress.unwrap(emailAddress): java.lang.String)
      .domainNames(domainNames.map { item =>
        SetupDomainName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .certificateProvider(certificateProvider.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.SetupInstanceHttpsRequest.ReadOnly =
    zio.aws.lightsail.model.SetupInstanceHttpsRequest.wrap(buildAwsValue())
}
object SetupInstanceHttpsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.SetupInstanceHttpsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.SetupInstanceHttpsRequest =
      zio.aws.lightsail.model.SetupInstanceHttpsRequest(
        instanceName,
        emailAddress,
        domainNames,
        certificateProvider
      )
    def instanceName: ResourceName
    def emailAddress: EmailAddress
    def domainNames: List[SetupDomainName]
    def certificateProvider: zio.aws.lightsail.model.CertificateProvider
    def getInstanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceName)
    def getEmailAddress: ZIO[Any, Nothing, EmailAddress] =
      ZIO.succeed(emailAddress)
    def getDomainNames: ZIO[Any, Nothing, List[SetupDomainName]] =
      ZIO.succeed(domainNames)
    def getCertificateProvider
        : ZIO[Any, Nothing, zio.aws.lightsail.model.CertificateProvider] =
      ZIO.succeed(certificateProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.SetupInstanceHttpsRequest
  ) extends zio.aws.lightsail.model.SetupInstanceHttpsRequest.ReadOnly {
    override val instanceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.instanceName())
    override val emailAddress: EmailAddress =
      zio.aws.lightsail.model.primitives.EmailAddress(impl.emailAddress())
    override val domainNames: List[SetupDomainName] = impl
      .domainNames()
      .asScala
      .map { item =>
        zio.aws.lightsail.model.primitives.SetupDomainName(item)
      }
      .toList
    override val certificateProvider
        : zio.aws.lightsail.model.CertificateProvider =
      zio.aws.lightsail.model.CertificateProvider
        .wrap(impl.certificateProvider())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.SetupInstanceHttpsRequest
  ): zio.aws.lightsail.model.SetupInstanceHttpsRequest.ReadOnly = new Wrapper(
    impl
  )
}
