package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{SetupDomainName, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SetupRequest(
    instanceName: Optional[ResourceName] = Optional.Absent,
    domainNames: Optional[Iterable[SetupDomainName]] = Optional.Absent,
    certificateProvider: Optional[zio.aws.lightsail.model.CertificateProvider] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.SetupRequest = {
    import SetupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.SetupRequest
      .builder()
      .optionallyWith(
        instanceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.instanceName)
      .optionallyWith(
        domainNames.map(value =>
          value.map { item =>
            SetupDomainName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.domainNames)
      .optionallyWith(certificateProvider.map(value => value.unwrap))(
        _.certificateProvider
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.SetupRequest.ReadOnly =
    zio.aws.lightsail.model.SetupRequest.wrap(buildAwsValue())
}
object SetupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.SetupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.SetupRequest =
      zio.aws.lightsail.model.SetupRequest(
        instanceName.map(value => value),
        domainNames.map(value => value),
        certificateProvider.map(value => value)
      )
    def instanceName: Optional[ResourceName]
    def domainNames: Optional[List[SetupDomainName]]
    def certificateProvider
        : Optional[zio.aws.lightsail.model.CertificateProvider]
    def getInstanceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("instanceName", instanceName)
    def getDomainNames: ZIO[Any, AwsError, List[SetupDomainName]] =
      AwsError.unwrapOptionField("domainNames", domainNames)
    def getCertificateProvider
        : ZIO[Any, AwsError, zio.aws.lightsail.model.CertificateProvider] =
      AwsError.unwrapOptionField("certificateProvider", certificateProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.SetupRequest
  ) extends zio.aws.lightsail.model.SetupRequest.ReadOnly {
    override val instanceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val domainNames: Optional[List[SetupDomainName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.primitives.SetupDomainName(item)
          }.toList
        )
    override val certificateProvider
        : Optional[zio.aws.lightsail.model.CertificateProvider] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateProvider())
        .map(value => zio.aws.lightsail.model.CertificateProvider.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.SetupRequest
  ): zio.aws.lightsail.model.SetupRequest.ReadOnly = new Wrapper(impl)
}
