package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait SetupStatus {
  def unwrap: software.amazon.awssdk.services.lightsail.model.SetupStatus
}
object SetupStatus {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.SetupStatus
  ): zio.aws.lightsail.model.SetupStatus = value match {
    case software.amazon.awssdk.services.lightsail.model.SetupStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.SetupStatus.SUCCEEDED =>
      val r = succeeded
      r
    case software.amazon.awssdk.services.lightsail.model.SetupStatus.FAILED =>
      val r = failed
      r
    case software.amazon.awssdk.services.lightsail.model.SetupStatus.IN_PROGRESS =>
      val r = inProgress
      r
  }
  case object unknownToSdkVersion extends zio.aws.lightsail.model.SetupStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.SetupStatus =
      software.amazon.awssdk.services.lightsail.model.SetupStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object succeeded extends zio.aws.lightsail.model.SetupStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.SetupStatus =
      software.amazon.awssdk.services.lightsail.model.SetupStatus.SUCCEEDED
  }
  case object failed extends zio.aws.lightsail.model.SetupStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.SetupStatus =
      software.amazon.awssdk.services.lightsail.model.SetupStatus.FAILED
  }
  case object inProgress extends zio.aws.lightsail.model.SetupStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.SetupStatus =
      software.amazon.awssdk.services.lightsail.model.SetupStatus.IN_PROGRESS
  }
}
