package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartGuiSessionRequest(resourceName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.StartGuiSessionRequest = {
    import StartGuiSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.StartGuiSessionRequest
      .builder()
      .resourceName(ResourceName.unwrap(resourceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.StartGuiSessionRequest.ReadOnly =
    zio.aws.lightsail.model.StartGuiSessionRequest.wrap(buildAwsValue())
}
object StartGuiSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.StartGuiSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.StartGuiSessionRequest =
      zio.aws.lightsail.model.StartGuiSessionRequest(resourceName)
    def resourceName: ResourceName
    def getResourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(resourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.StartGuiSessionRequest
  ) extends zio.aws.lightsail.model.StartGuiSessionRequest.ReadOnly {
    override val resourceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.resourceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.StartGuiSessionRequest
  ): zio.aws.lightsail.model.StartGuiSessionRequest.ReadOnly = new Wrapper(impl)
}
