package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartInstanceRequest(instanceName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.StartInstanceRequest = {
    import StartInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.StartInstanceRequest
      .builder()
      .instanceName(ResourceName.unwrap(instanceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.StartInstanceRequest.ReadOnly =
    zio.aws.lightsail.model.StartInstanceRequest.wrap(buildAwsValue())
}
object StartInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.StartInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.StartInstanceRequest =
      zio.aws.lightsail.model.StartInstanceRequest(instanceName)
    def instanceName: ResourceName
    def getInstanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.StartInstanceRequest
  ) extends zio.aws.lightsail.model.StartInstanceRequest.ReadOnly {
    override val instanceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.instanceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.StartInstanceRequest
  ): zio.aws.lightsail.model.StartInstanceRequest.ReadOnly = new Wrapper(impl)
}
