package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait Status {
  def unwrap: software.amazon.awssdk.services.lightsail.model.Status
}
object Status {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.Status
  ): zio.aws.lightsail.model.Status = value match {
    case software.amazon.awssdk.services.lightsail.model.Status.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.Status.START_EXPIRED =>
      val r = startExpired
      r
    case software.amazon.awssdk.services.lightsail.model.Status.NOT_STARTED =>
      val r = notStarted
      r
    case software.amazon.awssdk.services.lightsail.model.Status.STARTED =>
      val r = started
      r
    case software.amazon.awssdk.services.lightsail.model.Status.STARTING =>
      val r = starting
      r
    case software.amazon.awssdk.services.lightsail.model.Status.STOPPED =>
      val r = stopped
      r
    case software.amazon.awssdk.services.lightsail.model.Status.STOPPING =>
      val r = stopping
      r
    case software.amazon.awssdk.services.lightsail.model.Status.SETTING_UP_INSTANCE =>
      val r = settingUpInstance
      r
    case software.amazon.awssdk.services.lightsail.model.Status.FAILED_INSTANCE_CREATION =>
      val r = failedInstanceCreation
      r
    case software.amazon.awssdk.services.lightsail.model.Status.FAILED_STARTING_GUI_SESSION =>
      val r = failedStartingGUISession
      r
    case software.amazon.awssdk.services.lightsail.model.Status.FAILED_STOPPING_GUI_SESSION =>
      val r = failedStoppingGUISession
      r
  }
  case object unknownToSdkVersion extends zio.aws.lightsail.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.Status =
      software.amazon.awssdk.services.lightsail.model.Status.UNKNOWN_TO_SDK_VERSION
  }
  case object startExpired extends zio.aws.lightsail.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.Status =
      software.amazon.awssdk.services.lightsail.model.Status.START_EXPIRED
  }
  case object notStarted extends zio.aws.lightsail.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.Status =
      software.amazon.awssdk.services.lightsail.model.Status.NOT_STARTED
  }
  case object started extends zio.aws.lightsail.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.Status =
      software.amazon.awssdk.services.lightsail.model.Status.STARTED
  }
  case object starting extends zio.aws.lightsail.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.Status =
      software.amazon.awssdk.services.lightsail.model.Status.STARTING
  }
  case object stopped extends zio.aws.lightsail.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.Status =
      software.amazon.awssdk.services.lightsail.model.Status.STOPPED
  }
  case object stopping extends zio.aws.lightsail.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.Status =
      software.amazon.awssdk.services.lightsail.model.Status.STOPPING
  }
  case object settingUpInstance extends zio.aws.lightsail.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.Status =
      software.amazon.awssdk.services.lightsail.model.Status.SETTING_UP_INSTANCE
  }
  case object failedInstanceCreation extends zio.aws.lightsail.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.Status =
      software.amazon.awssdk.services.lightsail.model.Status.FAILED_INSTANCE_CREATION
  }
  case object failedStartingGUISession extends zio.aws.lightsail.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.Status =
      software.amazon.awssdk.services.lightsail.model.Status.FAILED_STARTING_GUI_SESSION
  }
  case object failedStoppingGUISession extends zio.aws.lightsail.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.Status =
      software.amazon.awssdk.services.lightsail.model.Status.FAILED_STOPPING_GUI_SESSION
  }
}
