package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopGuiSessionRequest(resourceName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.StopGuiSessionRequest = {
    import StopGuiSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.StopGuiSessionRequest
      .builder()
      .resourceName(ResourceName.unwrap(resourceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.StopGuiSessionRequest.ReadOnly =
    zio.aws.lightsail.model.StopGuiSessionRequest.wrap(buildAwsValue())
}
object StopGuiSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.StopGuiSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.StopGuiSessionRequest =
      zio.aws.lightsail.model.StopGuiSessionRequest(resourceName)
    def resourceName: ResourceName
    def getResourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(resourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.StopGuiSessionRequest
  ) extends zio.aws.lightsail.model.StopGuiSessionRequest.ReadOnly {
    override val resourceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.resourceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.StopGuiSessionRequest
  ): zio.aws.lightsail.model.StopGuiSessionRequest.ReadOnly = new Wrapper(impl)
}
