package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopInstanceOnIdleRequest(
    threshold: Optional[String] = Optional.Absent,
    duration: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.StopInstanceOnIdleRequest = {
    import StopInstanceOnIdleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.StopInstanceOnIdleRequest
      .builder()
      .optionallyWith(threshold.map(value => value: java.lang.String))(
        _.threshold
      )
      .optionallyWith(duration.map(value => value: java.lang.String))(
        _.duration
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.StopInstanceOnIdleRequest.ReadOnly =
    zio.aws.lightsail.model.StopInstanceOnIdleRequest.wrap(buildAwsValue())
}
object StopInstanceOnIdleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.StopInstanceOnIdleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.StopInstanceOnIdleRequest =
      zio.aws.lightsail.model.StopInstanceOnIdleRequest(
        threshold.map(value => value),
        duration.map(value => value)
      )
    def threshold: Optional[String]
    def duration: Optional[String]
    def getThreshold: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("threshold", threshold)
    def getDuration: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("duration", duration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.StopInstanceOnIdleRequest
  ) extends zio.aws.lightsail.model.StopInstanceOnIdleRequest.ReadOnly {
    override val threshold: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.threshold())
      .map(value => value: String)
    override val duration: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.StopInstanceOnIdleRequest
  ): zio.aws.lightsail.model.StopInstanceOnIdleRequest.ReadOnly = new Wrapper(
    impl
  )
}
