package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.IsoDate
import scala.jdk.CollectionConverters._
final case class TimePeriod(
    start: Optional[IsoDate] = Optional.Absent,
    end: Optional[IsoDate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.TimePeriod = {
    import TimePeriod.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.TimePeriod
      .builder()
      .optionallyWith(start.map(value => IsoDate.unwrap(value): Instant))(
        _.start
      )
      .optionallyWith(end.map(value => IsoDate.unwrap(value): Instant))(_.end)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.TimePeriod.ReadOnly =
    zio.aws.lightsail.model.TimePeriod.wrap(buildAwsValue())
}
object TimePeriod {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.TimePeriod
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.TimePeriod = zio.aws.lightsail.model
      .TimePeriod(start.map(value => value), end.map(value => value))
    def start: Optional[IsoDate]
    def end: Optional[IsoDate]
    def getStart: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("start", start)
    def getEnd: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("end", end)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.TimePeriod
  ) extends zio.aws.lightsail.model.TimePeriod.ReadOnly {
    override val start: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.start())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val end: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.end())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.TimePeriod
  ): zio.aws.lightsail.model.TimePeriod.ReadOnly = new Wrapper(impl)
}
