package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{Integer, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateInstanceMetadataOptionsRequest(
    instanceName: ResourceName,
    httpTokens: Optional[zio.aws.lightsail.model.HttpTokens] = Optional.Absent,
    httpEndpoint: Optional[zio.aws.lightsail.model.HttpEndpoint] =
      Optional.Absent,
    httpPutResponseHopLimit: Optional[Integer] = Optional.Absent,
    httpProtocolIpv6: Optional[zio.aws.lightsail.model.HttpProtocolIpv6] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateInstanceMetadataOptionsRequest = {
    import UpdateInstanceMetadataOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateInstanceMetadataOptionsRequest
      .builder()
      .instanceName(ResourceName.unwrap(instanceName): java.lang.String)
      .optionallyWith(httpTokens.map(value => value.unwrap))(_.httpTokens)
      .optionallyWith(httpEndpoint.map(value => value.unwrap))(_.httpEndpoint)
      .optionallyWith(
        httpPutResponseHopLimit.map(value => value: java.lang.Integer)
      )(_.httpPutResponseHopLimit)
      .optionallyWith(httpProtocolIpv6.map(value => value.unwrap))(
        _.httpProtocolIpv6
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.UpdateInstanceMetadataOptionsRequest.ReadOnly =
    zio.aws.lightsail.model.UpdateInstanceMetadataOptionsRequest
      .wrap(buildAwsValue())
}
object UpdateInstanceMetadataOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateInstanceMetadataOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.UpdateInstanceMetadataOptionsRequest =
      zio.aws.lightsail.model.UpdateInstanceMetadataOptionsRequest(
        instanceName,
        httpTokens.map(value => value),
        httpEndpoint.map(value => value),
        httpPutResponseHopLimit.map(value => value),
        httpProtocolIpv6.map(value => value)
      )
    def instanceName: ResourceName
    def httpTokens: Optional[zio.aws.lightsail.model.HttpTokens]
    def httpEndpoint: Optional[zio.aws.lightsail.model.HttpEndpoint]
    def httpPutResponseHopLimit: Optional[Integer]
    def httpProtocolIpv6: Optional[zio.aws.lightsail.model.HttpProtocolIpv6]
    def getInstanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceName)
    def getHttpTokens: ZIO[Any, AwsError, zio.aws.lightsail.model.HttpTokens] =
      AwsError.unwrapOptionField("httpTokens", httpTokens)
    def getHttpEndpoint
        : ZIO[Any, AwsError, zio.aws.lightsail.model.HttpEndpoint] =
      AwsError.unwrapOptionField("httpEndpoint", httpEndpoint)
    def getHttpPutResponseHopLimit: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("httpPutResponseHopLimit", httpPutResponseHopLimit)
    def getHttpProtocolIpv6
        : ZIO[Any, AwsError, zio.aws.lightsail.model.HttpProtocolIpv6] =
      AwsError.unwrapOptionField("httpProtocolIpv6", httpProtocolIpv6)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateInstanceMetadataOptionsRequest
  ) extends zio.aws.lightsail.model.UpdateInstanceMetadataOptionsRequest.ReadOnly {
    override val instanceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.instanceName())
    override val httpTokens: Optional[zio.aws.lightsail.model.HttpTokens] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpTokens())
        .map(value => zio.aws.lightsail.model.HttpTokens.wrap(value))
    override val httpEndpoint: Optional[zio.aws.lightsail.model.HttpEndpoint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpEndpoint())
        .map(value => zio.aws.lightsail.model.HttpEndpoint.wrap(value))
    override val httpPutResponseHopLimit: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpPutResponseHopLimit())
        .map(value => value: Integer)
    override val httpProtocolIpv6
        : Optional[zio.aws.lightsail.model.HttpProtocolIpv6] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpProtocolIpv6())
        .map(value => zio.aws.lightsail.model.HttpProtocolIpv6.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateInstanceMetadataOptionsRequest
  ): zio.aws.lightsail.model.UpdateInstanceMetadataOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
