package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{SensitiveString, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateRelationalDatabaseRequest(
    relationalDatabaseName: ResourceName,
    masterUserPassword: Optional[SensitiveString] = Optional.Absent,
    rotateMasterUserPassword: Optional[Boolean] = Optional.Absent,
    preferredBackupWindow: Optional[String] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    enableBackupRetention: Optional[Boolean] = Optional.Absent,
    disableBackupRetention: Optional[Boolean] = Optional.Absent,
    publiclyAccessible: Optional[Boolean] = Optional.Absent,
    applyImmediately: Optional[Boolean] = Optional.Absent,
    caCertificateIdentifier: Optional[String] = Optional.Absent,
    relationalDatabaseBlueprintId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest = {
    import UpdateRelationalDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest
      .builder()
      .relationalDatabaseName(
        ResourceName.unwrap(relationalDatabaseName): java.lang.String
      )
      .optionallyWith(
        masterUserPassword.map(value =>
          SensitiveString.unwrap(value): java.lang.String
        )
      )(_.masterUserPassword)
      .optionallyWith(
        rotateMasterUserPassword.map(value => value: java.lang.Boolean)
      )(_.rotateMasterUserPassword)
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        enableBackupRetention.map(value => value: java.lang.Boolean)
      )(_.enableBackupRetention)
      .optionallyWith(
        disableBackupRetention.map(value => value: java.lang.Boolean)
      )(_.disableBackupRetention)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(
        _.applyImmediately
      )
      .optionallyWith(
        caCertificateIdentifier.map(value => value: java.lang.String)
      )(_.caCertificateIdentifier)
      .optionallyWith(
        relationalDatabaseBlueprintId.map(value => value: java.lang.String)
      )(_.relationalDatabaseBlueprintId)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.UpdateRelationalDatabaseRequest.ReadOnly =
    zio.aws.lightsail.model.UpdateRelationalDatabaseRequest
      .wrap(buildAwsValue())
}
object UpdateRelationalDatabaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.UpdateRelationalDatabaseRequest =
      zio.aws.lightsail.model.UpdateRelationalDatabaseRequest(
        relationalDatabaseName,
        masterUserPassword.map(value => value),
        rotateMasterUserPassword.map(value => value),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        enableBackupRetention.map(value => value),
        disableBackupRetention.map(value => value),
        publiclyAccessible.map(value => value),
        applyImmediately.map(value => value),
        caCertificateIdentifier.map(value => value),
        relationalDatabaseBlueprintId.map(value => value)
      )
    def relationalDatabaseName: ResourceName
    def masterUserPassword: Optional[SensitiveString]
    def rotateMasterUserPassword: Optional[Boolean]
    def preferredBackupWindow: Optional[String]
    def preferredMaintenanceWindow: Optional[String]
    def enableBackupRetention: Optional[Boolean]
    def disableBackupRetention: Optional[Boolean]
    def publiclyAccessible: Optional[Boolean]
    def applyImmediately: Optional[Boolean]
    def caCertificateIdentifier: Optional[String]
    def relationalDatabaseBlueprintId: Optional[String]
    def getRelationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseName)
    def getMasterUserPassword: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getRotateMasterUserPassword: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("rotateMasterUserPassword", rotateMasterUserPassword)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getEnableBackupRetention: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableBackupRetention", enableBackupRetention)
    def getDisableBackupRetention: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("disableBackupRetention", disableBackupRetention)
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getApplyImmediately: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("applyImmediately", applyImmediately)
    def getCaCertificateIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("caCertificateIdentifier", caCertificateIdentifier)
    def getRelationalDatabaseBlueprintId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "relationalDatabaseBlueprintId",
        relationalDatabaseBlueprintId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest
  ) extends zio.aws.lightsail.model.UpdateRelationalDatabaseRequest.ReadOnly {
    override val relationalDatabaseName: ResourceName =
      zio.aws.lightsail.model.primitives
        .ResourceName(impl.relationalDatabaseName())
    override val masterUserPassword: Optional[SensitiveString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterUserPassword())
        .map(value => zio.aws.lightsail.model.primitives.SensitiveString(value))
    override val rotateMasterUserPassword: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rotateMasterUserPassword())
        .map(value => value: Boolean)
    override val preferredBackupWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredBackupWindow())
      .map(value => value: String)
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val enableBackupRetention: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableBackupRetention())
        .map(value => value: Boolean)
    override val disableBackupRetention: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableBackupRetention())
        .map(value => value: Boolean)
    override val publiclyAccessible: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publiclyAccessible())
      .map(value => value: Boolean)
    override val applyImmediately: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.applyImmediately())
      .map(value => value: Boolean)
    override val caCertificateIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.caCertificateIdentifier())
        .map(value => value: String)
    override val relationalDatabaseBlueprintId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relationalDatabaseBlueprintId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest
  ): zio.aws.lightsail.model.UpdateRelationalDatabaseRequest.ReadOnly =
    new Wrapper(impl)
}
