package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait ViewerMinimumTlsProtocolVersionEnum {
  def unwrap: software.amazon.awssdk.services.lightsail.model.ViewerMinimumTlsProtocolVersionEnum
}
object ViewerMinimumTlsProtocolVersionEnum {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.ViewerMinimumTlsProtocolVersionEnum
  ): zio.aws.lightsail.model.ViewerMinimumTlsProtocolVersionEnum = value match {
    case software.amazon.awssdk.services.lightsail.model.ViewerMinimumTlsProtocolVersionEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.ViewerMinimumTlsProtocolVersionEnum.TLS_V1_1_2016 =>
      val r = `TLSv1.1_2016`
      r
    case software.amazon.awssdk.services.lightsail.model.ViewerMinimumTlsProtocolVersionEnum.TLS_V1_2_2018 =>
      val r = `TLSv1.2_2018`
      r
    case software.amazon.awssdk.services.lightsail.model.ViewerMinimumTlsProtocolVersionEnum.TLS_V1_2_2019 =>
      val r = `TLSv1.2_2019`
      r
    case software.amazon.awssdk.services.lightsail.model.ViewerMinimumTlsProtocolVersionEnum.TLS_V1_2_2021 =>
      val r = `TLSv1.2_2021`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.ViewerMinimumTlsProtocolVersionEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ViewerMinimumTlsProtocolVersionEnum =
      software.amazon.awssdk.services.lightsail.model.ViewerMinimumTlsProtocolVersionEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object `TLSv1.1_2016`
      extends zio.aws.lightsail.model.ViewerMinimumTlsProtocolVersionEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ViewerMinimumTlsProtocolVersionEnum =
      software.amazon.awssdk.services.lightsail.model.ViewerMinimumTlsProtocolVersionEnum.TLS_V1_1_2016
  }
  case object `TLSv1.2_2018`
      extends zio.aws.lightsail.model.ViewerMinimumTlsProtocolVersionEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ViewerMinimumTlsProtocolVersionEnum =
      software.amazon.awssdk.services.lightsail.model.ViewerMinimumTlsProtocolVersionEnum.TLS_V1_2_2018
  }
  case object `TLSv1.2_2019`
      extends zio.aws.lightsail.model.ViewerMinimumTlsProtocolVersionEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ViewerMinimumTlsProtocolVersionEnum =
      software.amazon.awssdk.services.lightsail.model.ViewerMinimumTlsProtocolVersionEnum.TLS_V1_2_2019
  }
  case object `TLSv1.2_2021`
      extends zio.aws.lightsail.model.ViewerMinimumTlsProtocolVersionEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ViewerMinimumTlsProtocolVersionEnum =
      software.amazon.awssdk.services.lightsail.model.ViewerMinimumTlsProtocolVersionEnum.TLS_V1_2_2021
  }
}
