package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AccessRules(
    getObject: Option[zio.aws.lightsail.model.AccessType] = None,
    allowPublicOverrides: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AccessRules = {
    import AccessRules.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AccessRules
      .builder()
      .optionallyWith(getObject.map(value => value.unwrap))(_.getObject)
      .optionallyWith(
        allowPublicOverrides.map(value => value: java.lang.Boolean)
      )(_.allowPublicOverrides)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.AccessRules.ReadOnly =
    zio.aws.lightsail.model.AccessRules.wrap(buildAwsValue())
}
object AccessRules {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AccessRules
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.AccessRules =
      zio.aws.lightsail.model.AccessRules(
        getObject.map(value => value),
        allowPublicOverrides.map(value => value)
      )
    def getObject: Option[zio.aws.lightsail.model.AccessType]
    def allowPublicOverrides: Option[Boolean]
    def getGetObject: ZIO[Any, AwsError, zio.aws.lightsail.model.AccessType] =
      AwsError.unwrapOptionField("getObject", getObject)
    def getAllowPublicOverrides: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allowPublicOverrides", allowPublicOverrides)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AccessRules
  ) extends zio.aws.lightsail.model.AccessRules.ReadOnly {
    override val getObject: Option[zio.aws.lightsail.model.AccessType] = scala
      .Option(impl.getObject())
      .map(value => zio.aws.lightsail.model.AccessType.wrap(value))
    override val allowPublicOverrides: Option[Boolean] =
      scala.Option(impl.allowPublicOverrides()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AccessRules
  ): zio.aws.lightsail.model.AccessRules.ReadOnly = new Wrapper(impl)
}
