package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.TimeOfDay
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AddOn(
    name: Option[String] = None,
    status: Option[String] = None,
    snapshotTimeOfDay: Option[TimeOfDay] = None,
    nextSnapshotTimeOfDay: Option[TimeOfDay] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.AddOn = {
    import AddOn.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AddOn
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        snapshotTimeOfDay.map(value =>
          TimeOfDay.unwrap(value): java.lang.String
        )
      )(_.snapshotTimeOfDay)
      .optionallyWith(
        nextSnapshotTimeOfDay.map(value =>
          TimeOfDay.unwrap(value): java.lang.String
        )
      )(_.nextSnapshotTimeOfDay)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.AddOn.ReadOnly =
    zio.aws.lightsail.model.AddOn.wrap(buildAwsValue())
}
object AddOn {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.AddOn] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.AddOn =
      zio.aws.lightsail.model.AddOn(
        name.map(value => value),
        status.map(value => value),
        snapshotTimeOfDay.map(value => value),
        nextSnapshotTimeOfDay.map(value => value)
      )
    def name: Option[String]
    def status: Option[String]
    def snapshotTimeOfDay: Option[TimeOfDay]
    def nextSnapshotTimeOfDay: Option[TimeOfDay]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getSnapshotTimeOfDay: ZIO[Any, AwsError, TimeOfDay] =
      AwsError.unwrapOptionField("snapshotTimeOfDay", snapshotTimeOfDay)
    def getNextSnapshotTimeOfDay: ZIO[Any, AwsError, TimeOfDay] =
      AwsError.unwrapOptionField("nextSnapshotTimeOfDay", nextSnapshotTimeOfDay)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AddOn
  ) extends zio.aws.lightsail.model.AddOn.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val snapshotTimeOfDay: Option[TimeOfDay] = scala
      .Option(impl.snapshotTimeOfDay())
      .map(value => zio.aws.lightsail.model.primitives.TimeOfDay(value))
    override val nextSnapshotTimeOfDay: Option[TimeOfDay] = scala
      .Option(impl.nextSnapshotTimeOfDay())
      .map(value => zio.aws.lightsail.model.primitives.TimeOfDay(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AddOn
  ): zio.aws.lightsail.model.AddOn.ReadOnly = new Wrapper(impl)
}
