package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AddOnRequest(
    addOnType: zio.aws.lightsail.model.AddOnType,
    autoSnapshotAddOnRequest: Option[
      zio.aws.lightsail.model.AutoSnapshotAddOnRequest
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AddOnRequest = {
    import AddOnRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AddOnRequest
      .builder()
      .addOnType(addOnType.unwrap)
      .optionallyWith(
        autoSnapshotAddOnRequest.map(value => value.buildAwsValue())
      )(_.autoSnapshotAddOnRequest)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.AddOnRequest.ReadOnly =
    zio.aws.lightsail.model.AddOnRequest.wrap(buildAwsValue())
}
object AddOnRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AddOnRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.AddOnRequest =
      zio.aws.lightsail.model.AddOnRequest(
        addOnType,
        autoSnapshotAddOnRequest.map(value => value.asEditable)
      )
    def addOnType: zio.aws.lightsail.model.AddOnType
    def autoSnapshotAddOnRequest
        : Option[zio.aws.lightsail.model.AutoSnapshotAddOnRequest.ReadOnly]
    def getAddOnType: ZIO[Any, Nothing, zio.aws.lightsail.model.AddOnType] =
      ZIO.succeed(addOnType)
    def getAutoSnapshotAddOnRequest: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.AutoSnapshotAddOnRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoSnapshotAddOnRequest",
      autoSnapshotAddOnRequest
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AddOnRequest
  ) extends zio.aws.lightsail.model.AddOnRequest.ReadOnly {
    override val addOnType: zio.aws.lightsail.model.AddOnType =
      zio.aws.lightsail.model.AddOnType.wrap(impl.addOnType())
    override val autoSnapshotAddOnRequest
        : Option[zio.aws.lightsail.model.AutoSnapshotAddOnRequest.ReadOnly] =
      scala
        .Option(impl.autoSnapshotAddOnRequest())
        .map(value =>
          zio.aws.lightsail.model.AutoSnapshotAddOnRequest.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AddOnRequest
  ): zio.aws.lightsail.model.AddOnRequest.ReadOnly = new Wrapper(impl)
}
