package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{Integer, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BucketBundle(
    bundleId: Option[NonEmptyString] = None,
    name: Option[NonEmptyString] = None,
    price: Option[Float] = None,
    storagePerMonthInGb: Option[Integer] = None,
    transferPerMonthInGb: Option[Integer] = None,
    isActive: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.BucketBundle = {
    import BucketBundle.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.BucketBundle
      .builder()
      .optionallyWith(
        bundleId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.bundleId)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(price.map(value => value: java.lang.Float))(_.price)
      .optionallyWith(
        storagePerMonthInGb.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.storagePerMonthInGb)
      .optionallyWith(
        transferPerMonthInGb.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.transferPerMonthInGb)
      .optionallyWith(isActive.map(value => value: java.lang.Boolean))(
        _.isActive
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.BucketBundle.ReadOnly =
    zio.aws.lightsail.model.BucketBundle.wrap(buildAwsValue())
}
object BucketBundle {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.BucketBundle
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.BucketBundle =
      zio.aws.lightsail.model.BucketBundle(
        bundleId.map(value => value),
        name.map(value => value),
        price.map(value => value),
        storagePerMonthInGb.map(value => value),
        transferPerMonthInGb.map(value => value),
        isActive.map(value => value)
      )
    def bundleId: Option[NonEmptyString]
    def name: Option[NonEmptyString]
    def price: Option[Float]
    def storagePerMonthInGb: Option[Integer]
    def transferPerMonthInGb: Option[Integer]
    def isActive: Option[Boolean]
    def getBundleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("bundleId", bundleId)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getPrice: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("price", price)
    def getStoragePerMonthInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("storagePerMonthInGb", storagePerMonthInGb)
    def getTransferPerMonthInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("transferPerMonthInGb", transferPerMonthInGb)
    def getIsActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isActive", isActive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.BucketBundle
  ) extends zio.aws.lightsail.model.BucketBundle.ReadOnly {
    override val bundleId: Option[NonEmptyString] = scala
      .Option(impl.bundleId())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val price: Option[Float] =
      scala.Option(impl.price()).map(value => value: Float)
    override val storagePerMonthInGb: Option[Integer] = scala
      .Option(impl.storagePerMonthInGb())
      .map(value => zio.aws.lightsail.model.primitives.Integer(value))
    override val transferPerMonthInGb: Option[Integer] = scala
      .Option(impl.transferPerMonthInGb())
      .map(value => zio.aws.lightsail.model.primitives.Integer(value))
    override val isActive: Option[Boolean] =
      scala.Option(impl.isActive()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.BucketBundle
  ): zio.aws.lightsail.model.BucketBundle.ReadOnly = new Wrapper(impl)
}
