package zio.aws.lightsail.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{
  SerialNumber,
  IssuerCA,
  IsoDate,
  EligibleToRenew,
  InUseResourceCount,
  DomainName,
  CertificateName,
  RevocationReason,
  KeyAlgorithm,
  RequestFailureReason,
  NonEmptyString
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Certificate(
    arn: Option[NonEmptyString] = None,
    name: Option[CertificateName] = None,
    domainName: Option[DomainName] = None,
    status: Option[zio.aws.lightsail.model.CertificateStatus] = None,
    serialNumber: Option[SerialNumber] = None,
    subjectAlternativeNames: Option[Iterable[DomainName]] = None,
    domainValidationRecords: Option[
      Iterable[zio.aws.lightsail.model.DomainValidationRecord]
    ] = None,
    requestFailureReason: Option[RequestFailureReason] = None,
    inUseResourceCount: Option[InUseResourceCount] = None,
    keyAlgorithm: Option[KeyAlgorithm] = None,
    createdAt: Option[IsoDate] = None,
    issuedAt: Option[IsoDate] = None,
    issuerCA: Option[IssuerCA] = None,
    notBefore: Option[IsoDate] = None,
    notAfter: Option[IsoDate] = None,
    eligibleToRenew: Option[EligibleToRenew] = None,
    renewalSummary: Option[zio.aws.lightsail.model.RenewalSummary] = None,
    revokedAt: Option[IsoDate] = None,
    revocationReason: Option[RevocationReason] = None,
    tags: Option[Iterable[zio.aws.lightsail.model.Tag]] = None,
    supportCode: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Certificate = {
    import Certificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Certificate
      .builder()
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => CertificateName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        serialNumber.map(value => SerialNumber.unwrap(value): java.lang.String)
      )(_.serialNumber)
      .optionallyWith(
        subjectAlternativeNames.map(value =>
          value.map { item =>
            DomainName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subjectAlternativeNames)
      .optionallyWith(
        domainValidationRecords.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainValidationRecords)
      .optionallyWith(
        requestFailureReason.map(value =>
          RequestFailureReason.unwrap(value): java.lang.String
        )
      )(_.requestFailureReason)
      .optionallyWith(
        inUseResourceCount.map(value =>
          InUseResourceCount.unwrap(value): Integer
        )
      )(_.inUseResourceCount)
      .optionallyWith(
        keyAlgorithm.map(value => KeyAlgorithm.unwrap(value): java.lang.String)
      )(_.keyAlgorithm)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(issuedAt.map(value => IsoDate.unwrap(value): Instant))(
        _.issuedAt
      )
      .optionallyWith(
        issuerCA.map(value => IssuerCA.unwrap(value): java.lang.String)
      )(_.issuerCA)
      .optionallyWith(notBefore.map(value => IsoDate.unwrap(value): Instant))(
        _.notBefore
      )
      .optionallyWith(notAfter.map(value => IsoDate.unwrap(value): Instant))(
        _.notAfter
      )
      .optionallyWith(
        eligibleToRenew.map(value =>
          EligibleToRenew.unwrap(value): java.lang.String
        )
      )(_.eligibleToRenew)
      .optionallyWith(renewalSummary.map(value => value.buildAwsValue()))(
        _.renewalSummary
      )
      .optionallyWith(revokedAt.map(value => IsoDate.unwrap(value): Instant))(
        _.revokedAt
      )
      .optionallyWith(
        revocationReason.map(value =>
          RevocationReason.unwrap(value): java.lang.String
        )
      )(_.revocationReason)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.Certificate.ReadOnly =
    zio.aws.lightsail.model.Certificate.wrap(buildAwsValue())
}
object Certificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.Certificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.Certificate =
      zio.aws.lightsail.model.Certificate(
        arn.map(value => value),
        name.map(value => value),
        domainName.map(value => value),
        status.map(value => value),
        serialNumber.map(value => value),
        subjectAlternativeNames.map(value => value),
        domainValidationRecords.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        requestFailureReason.map(value => value),
        inUseResourceCount.map(value => value),
        keyAlgorithm.map(value => value),
        createdAt.map(value => value),
        issuedAt.map(value => value),
        issuerCA.map(value => value),
        notBefore.map(value => value),
        notAfter.map(value => value),
        eligibleToRenew.map(value => value),
        renewalSummary.map(value => value.asEditable),
        revokedAt.map(value => value),
        revocationReason.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        supportCode.map(value => value)
      )
    def arn: Option[NonEmptyString]
    def name: Option[CertificateName]
    def domainName: Option[DomainName]
    def status: Option[zio.aws.lightsail.model.CertificateStatus]
    def serialNumber: Option[SerialNumber]
    def subjectAlternativeNames: Option[List[DomainName]]
    def domainValidationRecords
        : Option[List[zio.aws.lightsail.model.DomainValidationRecord.ReadOnly]]
    def requestFailureReason: Option[RequestFailureReason]
    def inUseResourceCount: Option[InUseResourceCount]
    def keyAlgorithm: Option[KeyAlgorithm]
    def createdAt: Option[IsoDate]
    def issuedAt: Option[IsoDate]
    def issuerCA: Option[IssuerCA]
    def notBefore: Option[IsoDate]
    def notAfter: Option[IsoDate]
    def eligibleToRenew: Option[EligibleToRenew]
    def renewalSummary: Option[zio.aws.lightsail.model.RenewalSummary.ReadOnly]
    def revokedAt: Option[IsoDate]
    def revocationReason: Option[RevocationReason]
    def tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def supportCode: Option[String]
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, CertificateName] =
      AwsError.unwrapOptionField("name", name)
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.lightsail.model.CertificateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSerialNumber: ZIO[Any, AwsError, SerialNumber] =
      AwsError.unwrapOptionField("serialNumber", serialNumber)
    def getSubjectAlternativeNames: ZIO[Any, AwsError, List[DomainName]] =
      AwsError.unwrapOptionField(
        "subjectAlternativeNames",
        subjectAlternativeNames
      )
    def getDomainValidationRecords: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.DomainValidationRecord.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainValidationRecords",
      domainValidationRecords
    )
    def getRequestFailureReason: ZIO[Any, AwsError, RequestFailureReason] =
      AwsError.unwrapOptionField("requestFailureReason", requestFailureReason)
    def getInUseResourceCount: ZIO[Any, AwsError, InUseResourceCount] =
      AwsError.unwrapOptionField("inUseResourceCount", inUseResourceCount)
    def getKeyAlgorithm: ZIO[Any, AwsError, KeyAlgorithm] =
      AwsError.unwrapOptionField("keyAlgorithm", keyAlgorithm)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getIssuedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("issuedAt", issuedAt)
    def getIssuerCA: ZIO[Any, AwsError, IssuerCA] =
      AwsError.unwrapOptionField("issuerCA", issuerCA)
    def getNotBefore: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("notBefore", notBefore)
    def getNotAfter: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("notAfter", notAfter)
    def getEligibleToRenew: ZIO[Any, AwsError, EligibleToRenew] =
      AwsError.unwrapOptionField("eligibleToRenew", eligibleToRenew)
    def getRenewalSummary
        : ZIO[Any, AwsError, zio.aws.lightsail.model.RenewalSummary.ReadOnly] =
      AwsError.unwrapOptionField("renewalSummary", renewalSummary)
    def getRevokedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("revokedAt", revokedAt)
    def getRevocationReason: ZIO[Any, AwsError, RevocationReason] =
      AwsError.unwrapOptionField("revocationReason", revocationReason)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Certificate
  ) extends zio.aws.lightsail.model.Certificate.ReadOnly {
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val name: Option[CertificateName] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.CertificateName(value))
    override val domainName: Option[DomainName] = scala
      .Option(impl.domainName())
      .map(value => zio.aws.lightsail.model.primitives.DomainName(value))
    override val status: Option[zio.aws.lightsail.model.CertificateStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.lightsail.model.CertificateStatus.wrap(value))
    override val serialNumber: Option[SerialNumber] = scala
      .Option(impl.serialNumber())
      .map(value => zio.aws.lightsail.model.primitives.SerialNumber(value))
    override val subjectAlternativeNames: Option[List[DomainName]] = scala
      .Option(impl.subjectAlternativeNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.primitives.DomainName(item)
        }.toList
      )
    override val domainValidationRecords: Option[
      List[zio.aws.lightsail.model.DomainValidationRecord.ReadOnly]
    ] = scala
      .Option(impl.domainValidationRecords())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.DomainValidationRecord.wrap(item)
        }.toList
      )
    override val requestFailureReason: Option[RequestFailureReason] = scala
      .Option(impl.requestFailureReason())
      .map(value =>
        zio.aws.lightsail.model.primitives.RequestFailureReason(value)
      )
    override val inUseResourceCount: Option[InUseResourceCount] = scala
      .Option(impl.inUseResourceCount())
      .map(value =>
        zio.aws.lightsail.model.primitives.InUseResourceCount(value)
      )
    override val keyAlgorithm: Option[KeyAlgorithm] = scala
      .Option(impl.keyAlgorithm())
      .map(value => zio.aws.lightsail.model.primitives.KeyAlgorithm(value))
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val issuedAt: Option[IsoDate] = scala
      .Option(impl.issuedAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val issuerCA: Option[IssuerCA] = scala
      .Option(impl.issuerCA())
      .map(value => zio.aws.lightsail.model.primitives.IssuerCA(value))
    override val notBefore: Option[IsoDate] = scala
      .Option(impl.notBefore())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val notAfter: Option[IsoDate] = scala
      .Option(impl.notAfter())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val eligibleToRenew: Option[EligibleToRenew] = scala
      .Option(impl.eligibleToRenew())
      .map(value => zio.aws.lightsail.model.primitives.EligibleToRenew(value))
    override val renewalSummary
        : Option[zio.aws.lightsail.model.RenewalSummary.ReadOnly] = scala
      .Option(impl.renewalSummary())
      .map(value => zio.aws.lightsail.model.RenewalSummary.wrap(value))
    override val revokedAt: Option[IsoDate] = scala
      .Option(impl.revokedAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val revocationReason: Option[RevocationReason] = scala
      .Option(impl.revocationReason())
      .map(value => zio.aws.lightsail.model.primitives.RevocationReason(value))
    override val tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val supportCode: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Certificate
  ): zio.aws.lightsail.model.Certificate.ReadOnly = new Wrapper(impl)
}
