package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CloseInstancePublicPortsResponse(
    operation: Option[zio.aws.lightsail.model.Operation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsResponse = {
    import CloseInstancePublicPortsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsResponse
      .builder()
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.CloseInstancePublicPortsResponse.ReadOnly =
    zio.aws.lightsail.model.CloseInstancePublicPortsResponse
      .wrap(buildAwsValue())
}
object CloseInstancePublicPortsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CloseInstancePublicPortsResponse =
      zio.aws.lightsail.model.CloseInstancePublicPortsResponse(
        operation.map(value => value.asEditable)
      )
    def operation: Option[zio.aws.lightsail.model.Operation.ReadOnly]
    def getOperation
        : ZIO[Any, AwsError, zio.aws.lightsail.model.Operation.ReadOnly] =
      AwsError.unwrapOptionField("operation", operation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsResponse
  ) extends zio.aws.lightsail.model.CloseInstancePublicPortsResponse.ReadOnly {
    override val operation: Option[zio.aws.lightsail.model.Operation.ReadOnly] =
      scala
        .Option(impl.operation())
        .map(value => zio.aws.lightsail.model.Operation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsResponse
  ): zio.aws.lightsail.model.CloseInstancePublicPortsResponse.ReadOnly =
    new Wrapper(impl)
}
