package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  IsoDate,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CloudFormationStackRecord(
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[zio.aws.lightsail.model.ResourceLocation] = None,
    resourceType: Option[zio.aws.lightsail.model.ResourceType] = None,
    state: Option[zio.aws.lightsail.model.RecordState] = None,
    sourceInfo: Option[
      Iterable[zio.aws.lightsail.model.CloudFormationStackRecordSourceInfo]
    ] = None,
    destinationInfo: Option[zio.aws.lightsail.model.DestinationInfo] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecord = {
    import CloudFormationStackRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecord
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        sourceInfo.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceInfo)
      .optionallyWith(destinationInfo.map(value => value.buildAwsValue()))(
        _.destinationInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CloudFormationStackRecord.ReadOnly =
    zio.aws.lightsail.model.CloudFormationStackRecord.wrap(buildAwsValue())
}
object CloudFormationStackRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CloudFormationStackRecord =
      zio.aws.lightsail.model.CloudFormationStackRecord(
        name.map(value => value),
        arn.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        state.map(value => value),
        sourceInfo.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        destinationInfo.map(value => value.asEditable)
      )
    def name: Option[ResourceName]
    def arn: Option[NonEmptyString]
    def createdAt: Option[IsoDate]
    def location: Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Option[zio.aws.lightsail.model.ResourceType]
    def state: Option[zio.aws.lightsail.model.RecordState]
    def sourceInfo: Option[
      List[zio.aws.lightsail.model.CloudFormationStackRecordSourceInfo.ReadOnly]
    ]
    def destinationInfo
        : Option[zio.aws.lightsail.model.DestinationInfo.ReadOnly]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getState: ZIO[Any, AwsError, zio.aws.lightsail.model.RecordState] =
      AwsError.unwrapOptionField("state", state)
    def getSourceInfo: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.CloudFormationStackRecordSourceInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("sourceInfo", sourceInfo)
    def getDestinationInfo
        : ZIO[Any, AwsError, zio.aws.lightsail.model.DestinationInfo.ReadOnly] =
      AwsError.unwrapOptionField("destinationInfo", destinationInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecord
  ) extends zio.aws.lightsail.model.CloudFormationStackRecord.ReadOnly {
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly] = scala
      .Option(impl.location())
      .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Option[zio.aws.lightsail.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val state: Option[zio.aws.lightsail.model.RecordState] = scala
      .Option(impl.state())
      .map(value => zio.aws.lightsail.model.RecordState.wrap(value))
    override val sourceInfo: Option[
      List[zio.aws.lightsail.model.CloudFormationStackRecordSourceInfo.ReadOnly]
    ] = scala
      .Option(impl.sourceInfo())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.CloudFormationStackRecordSourceInfo.wrap(item)
        }.toList
      )
    override val destinationInfo
        : Option[zio.aws.lightsail.model.DestinationInfo.ReadOnly] = scala
      .Option(impl.destinationInfo())
      .map(value => zio.aws.lightsail.model.DestinationInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecord
  ): zio.aws.lightsail.model.CloudFormationStackRecord.ReadOnly = new Wrapper(
    impl
  )
}
