package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CloudFormationStackRecordSourceInfo(
    resourceType: Option[
      zio.aws.lightsail.model.CloudFormationStackRecordSourceType
    ] = None,
    name: Option[NonEmptyString] = None,
    arn: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceInfo = {
    import CloudFormationStackRecordSourceInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceInfo
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.CloudFormationStackRecordSourceInfo.ReadOnly =
    zio.aws.lightsail.model.CloudFormationStackRecordSourceInfo
      .wrap(buildAwsValue())
}
object CloudFormationStackRecordSourceInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.CloudFormationStackRecordSourceInfo =
      zio.aws.lightsail.model.CloudFormationStackRecordSourceInfo(
        resourceType.map(value => value),
        name.map(value => value),
        arn.map(value => value)
      )
    def resourceType
        : Option[zio.aws.lightsail.model.CloudFormationStackRecordSourceType]
    def name: Option[NonEmptyString]
    def arn: Option[NonEmptyString]
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.CloudFormationStackRecordSourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceInfo
  ) extends zio.aws.lightsail.model.CloudFormationStackRecordSourceInfo.ReadOnly {
    override val resourceType
        : Option[zio.aws.lightsail.model.CloudFormationStackRecordSourceType] =
      scala
        .Option(impl.resourceType())
        .map(value =>
          zio.aws.lightsail.model.CloudFormationStackRecordSourceType
            .wrap(value)
        )
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceInfo
  ): zio.aws.lightsail.model.CloudFormationStackRecordSourceInfo.ReadOnly =
    new Wrapper(impl)
}
