package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.IsoDate
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ContainerImage(
    image: Option[String] = None,
    digest: Option[String] = None,
    createdAt: Option[IsoDate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerImage = {
    import ContainerImage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerImage
      .builder()
      .optionallyWith(image.map(value => value: java.lang.String))(_.image)
      .optionallyWith(digest.map(value => value: java.lang.String))(_.digest)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.ContainerImage.ReadOnly =
    zio.aws.lightsail.model.ContainerImage.wrap(buildAwsValue())
}
object ContainerImage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerImage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ContainerImage =
      zio.aws.lightsail.model.ContainerImage(
        image.map(value => value),
        digest.map(value => value),
        createdAt.map(value => value)
      )
    def image: Option[String]
    def digest: Option[String]
    def createdAt: Option[IsoDate]
    def getImage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("image", image)
    def getDigest: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("digest", digest)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerImage
  ) extends zio.aws.lightsail.model.ContainerImage.ReadOnly {
    override val image: Option[String] =
      scala.Option(impl.image()).map(value => value: String)
    override val digest: Option[String] =
      scala.Option(impl.digest()).map(value => value: String)
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerImage
  ): zio.aws.lightsail.model.ContainerImage.ReadOnly = new Wrapper(impl)
}
