package zio.aws.lightsail.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{
  ContainerServiceScale,
  IsoDate,
  NonEmptyString,
  ContainerServiceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ContainerService(
    containerServiceName: Option[ContainerServiceName] = None,
    arn: Option[NonEmptyString] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[zio.aws.lightsail.model.ResourceLocation] = None,
    resourceType: Option[zio.aws.lightsail.model.ResourceType] = None,
    tags: Option[Iterable[zio.aws.lightsail.model.Tag]] = None,
    power: Option[zio.aws.lightsail.model.ContainerServicePowerName] = None,
    powerId: Option[String] = None,
    state: Option[zio.aws.lightsail.model.ContainerServiceState] = None,
    stateDetail: Option[zio.aws.lightsail.model.ContainerServiceStateDetail] =
      None,
    scale: Option[ContainerServiceScale] = None,
    currentDeployment: Option[
      zio.aws.lightsail.model.ContainerServiceDeployment
    ] = None,
    nextDeployment: Option[zio.aws.lightsail.model.ContainerServiceDeployment] =
      None,
    isDisabled: Option[Boolean] = None,
    principalArn: Option[String] = None,
    privateDomainName: Option[String] = None,
    publicDomainNames: Option[Map[String, Iterable[String]]] = None,
    url: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerService = {
    import ContainerService.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerService
      .builder()
      .optionallyWith(
        containerServiceName.map(value =>
          ContainerServiceName.unwrap(value): java.lang.String
        )
      )(_.containerServiceName)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(power.map(value => value.unwrap))(_.power)
      .optionallyWith(powerId.map(value => value: java.lang.String))(_.powerId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateDetail.map(value => value.buildAwsValue()))(
        _.stateDetail
      )
      .optionallyWith(
        scale.map(value => ContainerServiceScale.unwrap(value): Integer)
      )(_.scale)
      .optionallyWith(currentDeployment.map(value => value.buildAwsValue()))(
        _.currentDeployment
      )
      .optionallyWith(nextDeployment.map(value => value.buildAwsValue()))(
        _.nextDeployment
      )
      .optionallyWith(isDisabled.map(value => value: java.lang.Boolean))(
        _.isDisabled
      )
      .optionallyWith(principalArn.map(value => value: java.lang.String))(
        _.principalArn
      )
      .optionallyWith(privateDomainName.map(value => value: java.lang.String))(
        _.privateDomainName
      )
      .optionallyWith(
        publicDomainNames.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.publicDomainNames)
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.ContainerService.ReadOnly =
    zio.aws.lightsail.model.ContainerService.wrap(buildAwsValue())
}
object ContainerService {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerService
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ContainerService =
      zio.aws.lightsail.model.ContainerService(
        containerServiceName.map(value => value),
        arn.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        power.map(value => value),
        powerId.map(value => value),
        state.map(value => value),
        stateDetail.map(value => value.asEditable),
        scale.map(value => value),
        currentDeployment.map(value => value.asEditable),
        nextDeployment.map(value => value.asEditable),
        isDisabled.map(value => value),
        principalArn.map(value => value),
        privateDomainName.map(value => value),
        publicDomainNames.map(value => value),
        url.map(value => value)
      )
    def containerServiceName: Option[ContainerServiceName]
    def arn: Option[NonEmptyString]
    def createdAt: Option[IsoDate]
    def location: Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Option[zio.aws.lightsail.model.ResourceType]
    def tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def power: Option[zio.aws.lightsail.model.ContainerServicePowerName]
    def powerId: Option[String]
    def state: Option[zio.aws.lightsail.model.ContainerServiceState]
    def stateDetail
        : Option[zio.aws.lightsail.model.ContainerServiceStateDetail.ReadOnly]
    def scale: Option[ContainerServiceScale]
    def currentDeployment
        : Option[zio.aws.lightsail.model.ContainerServiceDeployment.ReadOnly]
    def nextDeployment
        : Option[zio.aws.lightsail.model.ContainerServiceDeployment.ReadOnly]
    def isDisabled: Option[Boolean]
    def principalArn: Option[String]
    def privateDomainName: Option[String]
    def publicDomainNames: Option[Map[String, List[String]]]
    def url: Option[String]
    def getContainerServiceName: ZIO[Any, AwsError, ContainerServiceName] =
      AwsError.unwrapOptionField("containerServiceName", containerServiceName)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPower: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerServicePowerName
    ] = AwsError.unwrapOptionField("power", power)
    def getPowerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("powerId", powerId)
    def getState
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ContainerServiceState] =
      AwsError.unwrapOptionField("state", state)
    def getStateDetail: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerServiceStateDetail.ReadOnly
    ] = AwsError.unwrapOptionField("stateDetail", stateDetail)
    def getScale: ZIO[Any, AwsError, ContainerServiceScale] =
      AwsError.unwrapOptionField("scale", scale)
    def getCurrentDeployment: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerServiceDeployment.ReadOnly
    ] = AwsError.unwrapOptionField("currentDeployment", currentDeployment)
    def getNextDeployment: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerServiceDeployment.ReadOnly
    ] = AwsError.unwrapOptionField("nextDeployment", nextDeployment)
    def getIsDisabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDisabled", isDisabled)
    def getPrincipalArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("principalArn", principalArn)
    def getPrivateDomainName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDomainName", privateDomainName)
    def getPublicDomainNames: ZIO[Any, AwsError, Map[String, List[String]]] =
      AwsError.unwrapOptionField("publicDomainNames", publicDomainNames)
    def getUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerService
  ) extends zio.aws.lightsail.model.ContainerService.ReadOnly {
    override val containerServiceName: Option[ContainerServiceName] = scala
      .Option(impl.containerServiceName())
      .map(value =>
        zio.aws.lightsail.model.primitives.ContainerServiceName(value)
      )
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly] = scala
      .Option(impl.location())
      .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Option[zio.aws.lightsail.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val power
        : Option[zio.aws.lightsail.model.ContainerServicePowerName] = scala
      .Option(impl.power())
      .map(value =>
        zio.aws.lightsail.model.ContainerServicePowerName.wrap(value)
      )
    override val powerId: Option[String] =
      scala.Option(impl.powerId()).map(value => value: String)
    override val state: Option[zio.aws.lightsail.model.ContainerServiceState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.lightsail.model.ContainerServiceState.wrap(value))
    override val stateDetail
        : Option[zio.aws.lightsail.model.ContainerServiceStateDetail.ReadOnly] =
      scala
        .Option(impl.stateDetail())
        .map(value =>
          zio.aws.lightsail.model.ContainerServiceStateDetail.wrap(value)
        )
    override val scale: Option[ContainerServiceScale] = scala
      .Option(impl.scale())
      .map(value =>
        zio.aws.lightsail.model.primitives.ContainerServiceScale(value)
      )
    override val currentDeployment
        : Option[zio.aws.lightsail.model.ContainerServiceDeployment.ReadOnly] =
      scala
        .Option(impl.currentDeployment())
        .map(value =>
          zio.aws.lightsail.model.ContainerServiceDeployment.wrap(value)
        )
    override val nextDeployment
        : Option[zio.aws.lightsail.model.ContainerServiceDeployment.ReadOnly] =
      scala
        .Option(impl.nextDeployment())
        .map(value =>
          zio.aws.lightsail.model.ContainerServiceDeployment.wrap(value)
        )
    override val isDisabled: Option[Boolean] =
      scala.Option(impl.isDisabled()).map(value => value: Boolean)
    override val principalArn: Option[String] =
      scala.Option(impl.principalArn()).map(value => value: String)
    override val privateDomainName: Option[String] =
      scala.Option(impl.privateDomainName()).map(value => value: String)
    override val publicDomainNames: Option[Map[String, List[String]]] = scala
      .Option(impl.publicDomainNames())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> value.asScala.map { item =>
              item: String
            }.toList
          })
          .toMap
      )
    override val url: Option[String] =
      scala.Option(impl.url()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerService
  ): zio.aws.lightsail.model.ContainerService.ReadOnly = new Wrapper(impl)
}
