package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ContainerServiceEndpoint(
    containerName: Option[String] = None,
    containerPort: Option[Integer] = None,
    healthCheck: Option[
      zio.aws.lightsail.model.ContainerServiceHealthCheckConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerServiceEndpoint = {
    import ContainerServiceEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceEndpoint
      .builder()
      .optionallyWith(containerName.map(value => value: java.lang.String))(
        _.containerName
      )
      .optionallyWith(
        containerPort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.containerPort)
      .optionallyWith(healthCheck.map(value => value.buildAwsValue()))(
        _.healthCheck
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.ContainerServiceEndpoint.ReadOnly =
    zio.aws.lightsail.model.ContainerServiceEndpoint.wrap(buildAwsValue())
}
object ContainerServiceEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerServiceEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ContainerServiceEndpoint =
      zio.aws.lightsail.model.ContainerServiceEndpoint(
        containerName.map(value => value),
        containerPort.map(value => value),
        healthCheck.map(value => value.asEditable)
      )
    def containerName: Option[String]
    def containerPort: Option[Integer]
    def healthCheck: Option[
      zio.aws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly
    ]
    def getContainerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerName", containerName)
    def getContainerPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("containerPort", containerPort)
    def getHealthCheck: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly
    ] = AwsError.unwrapOptionField("healthCheck", healthCheck)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceEndpoint
  ) extends zio.aws.lightsail.model.ContainerServiceEndpoint.ReadOnly {
    override val containerName: Option[String] =
      scala.Option(impl.containerName()).map(value => value: String)
    override val containerPort: Option[Integer] = scala
      .Option(impl.containerPort())
      .map(value => zio.aws.lightsail.model.primitives.Integer(value))
    override val healthCheck: Option[
      zio.aws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly
    ] = scala
      .Option(impl.healthCheck())
      .map(value =>
        zio.aws.lightsail.model.ContainerServiceHealthCheckConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceEndpoint
  ): zio.aws.lightsail.model.ContainerServiceEndpoint.ReadOnly = new Wrapper(
    impl
  )
}
