package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ContainerServiceHealthCheckConfig(
    healthyThreshold: Option[Integer] = None,
    unhealthyThreshold: Option[Integer] = None,
    timeoutSeconds: Option[Integer] = None,
    intervalSeconds: Option[Integer] = None,
    path: Option[String] = None,
    successCodes: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerServiceHealthCheckConfig = {
    import ContainerServiceHealthCheckConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceHealthCheckConfig
      .builder()
      .optionallyWith(
        healthyThreshold.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.healthyThreshold)
      .optionallyWith(
        unhealthyThreshold.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.unhealthyThreshold)
      .optionallyWith(
        timeoutSeconds.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.timeoutSeconds)
      .optionallyWith(
        intervalSeconds.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.intervalSeconds)
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(successCodes.map(value => value: java.lang.String))(
        _.successCodes
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly =
    zio.aws.lightsail.model.ContainerServiceHealthCheckConfig
      .wrap(buildAwsValue())
}
object ContainerServiceHealthCheckConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerServiceHealthCheckConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ContainerServiceHealthCheckConfig =
      zio.aws.lightsail.model.ContainerServiceHealthCheckConfig(
        healthyThreshold.map(value => value),
        unhealthyThreshold.map(value => value),
        timeoutSeconds.map(value => value),
        intervalSeconds.map(value => value),
        path.map(value => value),
        successCodes.map(value => value)
      )
    def healthyThreshold: Option[Integer]
    def unhealthyThreshold: Option[Integer]
    def timeoutSeconds: Option[Integer]
    def intervalSeconds: Option[Integer]
    def path: Option[String]
    def successCodes: Option[String]
    def getHealthyThreshold: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("healthyThreshold", healthyThreshold)
    def getUnhealthyThreshold: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("unhealthyThreshold", unhealthyThreshold)
    def getTimeoutSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("timeoutSeconds", timeoutSeconds)
    def getIntervalSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("intervalSeconds", intervalSeconds)
    def getPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", path)
    def getSuccessCodes: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("successCodes", successCodes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceHealthCheckConfig
  ) extends zio.aws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly {
    override val healthyThreshold: Option[Integer] = scala
      .Option(impl.healthyThreshold())
      .map(value => zio.aws.lightsail.model.primitives.Integer(value))
    override val unhealthyThreshold: Option[Integer] = scala
      .Option(impl.unhealthyThreshold())
      .map(value => zio.aws.lightsail.model.primitives.Integer(value))
    override val timeoutSeconds: Option[Integer] = scala
      .Option(impl.timeoutSeconds())
      .map(value => zio.aws.lightsail.model.primitives.Integer(value))
    override val intervalSeconds: Option[Integer] = scala
      .Option(impl.intervalSeconds())
      .map(value => zio.aws.lightsail.model.primitives.Integer(value))
    override val path: Option[String] =
      scala.Option(impl.path()).map(value => value: String)
    override val successCodes: Option[String] =
      scala.Option(impl.successCodes()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceHealthCheckConfig
  ): zio.aws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly =
    new Wrapper(impl)
}
