package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ContainerServiceStateDetail(
    code: Option[zio.aws.lightsail.model.ContainerServiceStateDetailCode] =
      None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerServiceStateDetail = {
    import ContainerServiceStateDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceStateDetail
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.ContainerServiceStateDetail.ReadOnly =
    zio.aws.lightsail.model.ContainerServiceStateDetail.wrap(buildAwsValue())
}
object ContainerServiceStateDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerServiceStateDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ContainerServiceStateDetail =
      zio.aws.lightsail.model.ContainerServiceStateDetail(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Option[zio.aws.lightsail.model.ContainerServiceStateDetailCode]
    def message: Option[String]
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerServiceStateDetailCode
    ] = AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceStateDetail
  ) extends zio.aws.lightsail.model.ContainerServiceStateDetail.ReadOnly {
    override val code
        : Option[zio.aws.lightsail.model.ContainerServiceStateDetailCode] =
      scala
        .Option(impl.code())
        .map(value =>
          zio.aws.lightsail.model.ContainerServiceStateDetailCode.wrap(value)
        )
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceStateDetail
  ): zio.aws.lightsail.model.ContainerServiceStateDetail.ReadOnly = new Wrapper(
    impl
  )
}
