package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CopySnapshotRequest(
    sourceSnapshotName: Option[ResourceName] = None,
    sourceResourceName: Option[String] = None,
    restoreDate: Option[String] = None,
    useLatestRestorableAutoSnapshot: Option[Boolean] = None,
    targetSnapshotName: ResourceName,
    sourceRegion: zio.aws.lightsail.model.RegionName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest = {
    import CopySnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest
      .builder()
      .optionallyWith(
        sourceSnapshotName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.sourceSnapshotName)
      .optionallyWith(sourceResourceName.map(value => value: java.lang.String))(
        _.sourceResourceName
      )
      .optionallyWith(restoreDate.map(value => value: java.lang.String))(
        _.restoreDate
      )
      .optionallyWith(
        useLatestRestorableAutoSnapshot.map(value => value: java.lang.Boolean)
      )(_.useLatestRestorableAutoSnapshot)
      .targetSnapshotName(
        ResourceName.unwrap(targetSnapshotName): java.lang.String
      )
      .sourceRegion(sourceRegion.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CopySnapshotRequest.ReadOnly =
    zio.aws.lightsail.model.CopySnapshotRequest.wrap(buildAwsValue())
}
object CopySnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CopySnapshotRequest =
      zio.aws.lightsail.model.CopySnapshotRequest(
        sourceSnapshotName.map(value => value),
        sourceResourceName.map(value => value),
        restoreDate.map(value => value),
        useLatestRestorableAutoSnapshot.map(value => value),
        targetSnapshotName,
        sourceRegion
      )
    def sourceSnapshotName: Option[ResourceName]
    def sourceResourceName: Option[String]
    def restoreDate: Option[String]
    def useLatestRestorableAutoSnapshot: Option[Boolean]
    def targetSnapshotName: ResourceName
    def sourceRegion: zio.aws.lightsail.model.RegionName
    def getSourceSnapshotName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("sourceSnapshotName", sourceSnapshotName)
    def getSourceResourceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceResourceName", sourceResourceName)
    def getRestoreDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("restoreDate", restoreDate)
    def getUseLatestRestorableAutoSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "useLatestRestorableAutoSnapshot",
        useLatestRestorableAutoSnapshot
      )
    def getTargetSnapshotName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(targetSnapshotName)
    def getSourceRegion: ZIO[Any, Nothing, zio.aws.lightsail.model.RegionName] =
      ZIO.succeed(sourceRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest
  ) extends zio.aws.lightsail.model.CopySnapshotRequest.ReadOnly {
    override val sourceSnapshotName: Option[ResourceName] = scala
      .Option(impl.sourceSnapshotName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val sourceResourceName: Option[String] =
      scala.Option(impl.sourceResourceName()).map(value => value: String)
    override val restoreDate: Option[String] =
      scala.Option(impl.restoreDate()).map(value => value: String)
    override val useLatestRestorableAutoSnapshot: Option[Boolean] = scala
      .Option(impl.useLatestRestorableAutoSnapshot())
      .map(value => value: Boolean)
    override val targetSnapshotName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.targetSnapshotName())
    override val sourceRegion: zio.aws.lightsail.model.RegionName =
      zio.aws.lightsail.model.RegionName.wrap(impl.sourceRegion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest
  ): zio.aws.lightsail.model.CopySnapshotRequest.ReadOnly = new Wrapper(impl)
}
