package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateBucketAccessKeyResponse(
    accessKey: Option[zio.aws.lightsail.model.AccessKey] = None,
    operations: Option[Iterable[zio.aws.lightsail.model.Operation]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyResponse = {
    import CreateBucketAccessKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyResponse
      .builder()
      .optionallyWith(accessKey.map(value => value.buildAwsValue()))(
        _.accessKey
      )
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operations)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.CreateBucketAccessKeyResponse.ReadOnly =
    zio.aws.lightsail.model.CreateBucketAccessKeyResponse.wrap(buildAwsValue())
}
object CreateBucketAccessKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateBucketAccessKeyResponse =
      zio.aws.lightsail.model.CreateBucketAccessKeyResponse(
        accessKey.map(value => value.asEditable),
        operations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def accessKey: Option[zio.aws.lightsail.model.AccessKey.ReadOnly]
    def operations: Option[List[zio.aws.lightsail.model.Operation.ReadOnly]]
    def getAccessKey
        : ZIO[Any, AwsError, zio.aws.lightsail.model.AccessKey.ReadOnly] =
      AwsError.unwrapOptionField("accessKey", accessKey)
    def getOperations
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Operation.ReadOnly]] =
      AwsError.unwrapOptionField("operations", operations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyResponse
  ) extends zio.aws.lightsail.model.CreateBucketAccessKeyResponse.ReadOnly {
    override val accessKey: Option[zio.aws.lightsail.model.AccessKey.ReadOnly] =
      scala
        .Option(impl.accessKey())
        .map(value => zio.aws.lightsail.model.AccessKey.wrap(value))
    override val operations
        : Option[List[zio.aws.lightsail.model.Operation.ReadOnly]] = scala
      .Option(impl.operations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.Operation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyResponse
  ): zio.aws.lightsail.model.CreateBucketAccessKeyResponse.ReadOnly =
    new Wrapper(impl)
}
