package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{DomainName, CertificateName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateCertificateRequest(
    certificateName: CertificateName,
    domainName: DomainName,
    subjectAlternativeNames: Option[Iterable[DomainName]] = None,
    tags: Option[Iterable[zio.aws.lightsail.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateCertificateRequest = {
    import CreateCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateCertificateRequest
      .builder()
      .certificateName(
        CertificateName.unwrap(certificateName): java.lang.String
      )
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        subjectAlternativeNames.map(value =>
          value.map { item =>
            DomainName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subjectAlternativeNames)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CreateCertificateRequest.ReadOnly =
    zio.aws.lightsail.model.CreateCertificateRequest.wrap(buildAwsValue())
}
object CreateCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateCertificateRequest =
      zio.aws.lightsail.model.CreateCertificateRequest(
        certificateName,
        domainName,
        subjectAlternativeNames.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def certificateName: CertificateName
    def domainName: DomainName
    def subjectAlternativeNames: Option[List[DomainName]]
    def tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def getCertificateName: ZIO[Any, Nothing, CertificateName] =
      ZIO.succeed(certificateName)
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getSubjectAlternativeNames: ZIO[Any, AwsError, List[DomainName]] =
      AwsError.unwrapOptionField(
        "subjectAlternativeNames",
        subjectAlternativeNames
      )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateCertificateRequest
  ) extends zio.aws.lightsail.model.CreateCertificateRequest.ReadOnly {
    override val certificateName: CertificateName =
      zio.aws.lightsail.model.primitives.CertificateName(impl.certificateName())
    override val domainName: DomainName =
      zio.aws.lightsail.model.primitives.DomainName(impl.domainName())
    override val subjectAlternativeNames: Option[List[DomainName]] = scala
      .Option(impl.subjectAlternativeNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.primitives.DomainName(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateCertificateRequest
  ): zio.aws.lightsail.model.CreateCertificateRequest.ReadOnly = new Wrapper(
    impl
  )
}
