package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateContainerServiceResponse(
    containerService: Option[zio.aws.lightsail.model.ContainerService] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateContainerServiceResponse = {
    import CreateContainerServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceResponse
      .builder()
      .optionallyWith(containerService.map(value => value.buildAwsValue()))(
        _.containerService
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.CreateContainerServiceResponse.ReadOnly =
    zio.aws.lightsail.model.CreateContainerServiceResponse.wrap(buildAwsValue())
}
object CreateContainerServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateContainerServiceResponse =
      zio.aws.lightsail.model.CreateContainerServiceResponse(
        containerService.map(value => value.asEditable)
      )
    def containerService
        : Option[zio.aws.lightsail.model.ContainerService.ReadOnly]
    def getContainerService: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ContainerService.ReadOnly
    ] = AwsError.unwrapOptionField("containerService", containerService)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceResponse
  ) extends zio.aws.lightsail.model.CreateContainerServiceResponse.ReadOnly {
    override val containerService
        : Option[zio.aws.lightsail.model.ContainerService.ReadOnly] = scala
      .Option(impl.containerService())
      .map(value => zio.aws.lightsail.model.ContainerService.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceResponse
  ): zio.aws.lightsail.model.CreateContainerServiceResponse.ReadOnly =
    new Wrapper(impl)
}
