package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  Integer,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDiskFromSnapshotRequest(
    diskName: ResourceName,
    diskSnapshotName: Option[ResourceName] = None,
    availabilityZone: NonEmptyString,
    sizeInGb: Integer,
    tags: Option[Iterable[zio.aws.lightsail.model.Tag]] = None,
    addOns: Option[Iterable[zio.aws.lightsail.model.AddOnRequest]] = None,
    sourceDiskName: Option[String] = None,
    restoreDate: Option[String] = None,
    useLatestRestorableAutoSnapshot: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest = {
    import CreateDiskFromSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest
      .builder()
      .diskName(ResourceName.unwrap(diskName): java.lang.String)
      .optionallyWith(
        diskSnapshotName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.diskSnapshotName)
      .availabilityZone(
        NonEmptyString.unwrap(availabilityZone): java.lang.String
      )
      .sizeInGb(Integer.unwrap(sizeInGb): java.lang.Integer)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        addOns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addOns)
      .optionallyWith(sourceDiskName.map(value => value: java.lang.String))(
        _.sourceDiskName
      )
      .optionallyWith(restoreDate.map(value => value: java.lang.String))(
        _.restoreDate
      )
      .optionallyWith(
        useLatestRestorableAutoSnapshot.map(value => value: java.lang.Boolean)
      )(_.useLatestRestorableAutoSnapshot)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.CreateDiskFromSnapshotRequest.ReadOnly =
    zio.aws.lightsail.model.CreateDiskFromSnapshotRequest.wrap(buildAwsValue())
}
object CreateDiskFromSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateDiskFromSnapshotRequest =
      zio.aws.lightsail.model.CreateDiskFromSnapshotRequest(
        diskName,
        diskSnapshotName.map(value => value),
        availabilityZone,
        sizeInGb,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        addOns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceDiskName.map(value => value),
        restoreDate.map(value => value),
        useLatestRestorableAutoSnapshot.map(value => value)
      )
    def diskName: ResourceName
    def diskSnapshotName: Option[ResourceName]
    def availabilityZone: NonEmptyString
    def sizeInGb: Integer
    def tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def addOns: Option[List[zio.aws.lightsail.model.AddOnRequest.ReadOnly]]
    def sourceDiskName: Option[String]
    def restoreDate: Option[String]
    def useLatestRestorableAutoSnapshot: Option[Boolean]
    def getDiskName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(diskName)
    def getDiskSnapshotName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("diskSnapshotName", diskSnapshotName)
    def getAvailabilityZone: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(availabilityZone)
    def getSizeInGb: ZIO[Any, Nothing, Integer] = ZIO.succeed(sizeInGb)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAddOns: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.AddOnRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("addOns", addOns)
    def getSourceDiskName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceDiskName", sourceDiskName)
    def getRestoreDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("restoreDate", restoreDate)
    def getUseLatestRestorableAutoSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "useLatestRestorableAutoSnapshot",
        useLatestRestorableAutoSnapshot
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest
  ) extends zio.aws.lightsail.model.CreateDiskFromSnapshotRequest.ReadOnly {
    override val diskName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.diskName())
    override val diskSnapshotName: Option[ResourceName] = scala
      .Option(impl.diskSnapshotName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val availabilityZone: NonEmptyString =
      zio.aws.lightsail.model.primitives.NonEmptyString(impl.availabilityZone())
    override val sizeInGb: Integer =
      zio.aws.lightsail.model.primitives.Integer(impl.sizeInGb())
    override val tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val addOns
        : Option[List[zio.aws.lightsail.model.AddOnRequest.ReadOnly]] = scala
      .Option(impl.addOns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.AddOnRequest.wrap(item)
        }.toList
      )
    override val sourceDiskName: Option[String] =
      scala.Option(impl.sourceDiskName()).map(value => value: String)
    override val restoreDate: Option[String] =
      scala.Option(impl.restoreDate()).map(value => value: String)
    override val useLatestRestorableAutoSnapshot: Option[Boolean] = scala
      .Option(impl.useLatestRestorableAutoSnapshot())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest
  ): zio.aws.lightsail.model.CreateDiskFromSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
