package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDistributionResponse(
    distribution: Option[zio.aws.lightsail.model.LightsailDistribution] = None,
    operation: Option[zio.aws.lightsail.model.Operation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse = {
    import CreateDistributionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse
      .builder()
      .optionallyWith(distribution.map(value => value.buildAwsValue()))(
        _.distribution
      )
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CreateDistributionResponse.ReadOnly =
    zio.aws.lightsail.model.CreateDistributionResponse.wrap(buildAwsValue())
}
object CreateDistributionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateDistributionResponse =
      zio.aws.lightsail.model.CreateDistributionResponse(
        distribution.map(value => value.asEditable),
        operation.map(value => value.asEditable)
      )
    def distribution
        : Option[zio.aws.lightsail.model.LightsailDistribution.ReadOnly]
    def operation: Option[zio.aws.lightsail.model.Operation.ReadOnly]
    def getDistribution: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.LightsailDistribution.ReadOnly
    ] = AwsError.unwrapOptionField("distribution", distribution)
    def getOperation
        : ZIO[Any, AwsError, zio.aws.lightsail.model.Operation.ReadOnly] =
      AwsError.unwrapOptionField("operation", operation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse
  ) extends zio.aws.lightsail.model.CreateDistributionResponse.ReadOnly {
    override val distribution
        : Option[zio.aws.lightsail.model.LightsailDistribution.ReadOnly] = scala
      .Option(impl.distribution())
      .map(value => zio.aws.lightsail.model.LightsailDistribution.wrap(value))
    override val operation: Option[zio.aws.lightsail.model.Operation.ReadOnly] =
      scala
        .Option(impl.operation())
        .map(value => zio.aws.lightsail.model.Operation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse
  ): zio.aws.lightsail.model.CreateDistributionResponse.ReadOnly = new Wrapper(
    impl
  )
}
