package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDomainResponse(
    operation: Option[zio.aws.lightsail.model.Operation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateDomainResponse = {
    import CreateDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDomainResponse
      .builder()
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CreateDomainResponse.ReadOnly =
    zio.aws.lightsail.model.CreateDomainResponse.wrap(buildAwsValue())
}
object CreateDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateDomainResponse =
      zio.aws.lightsail.model
        .CreateDomainResponse(operation.map(value => value.asEditable))
    def operation: Option[zio.aws.lightsail.model.Operation.ReadOnly]
    def getOperation
        : ZIO[Any, AwsError, zio.aws.lightsail.model.Operation.ReadOnly] =
      AwsError.unwrapOptionField("operation", operation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDomainResponse
  ) extends zio.aws.lightsail.model.CreateDomainResponse.ReadOnly {
    override val operation: Option[zio.aws.lightsail.model.Operation.ReadOnly] =
      scala
        .Option(impl.operation())
        .map(value => zio.aws.lightsail.model.Operation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDomainResponse
  ): zio.aws.lightsail.model.CreateDomainResponse.ReadOnly = new Wrapper(impl)
}
