package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{SensitiveString, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateRelationalDatabaseRequest(
    relationalDatabaseName: ResourceName,
    availabilityZone: Option[String] = None,
    relationalDatabaseBlueprintId: String,
    relationalDatabaseBundleId: String,
    masterDatabaseName: String,
    masterUsername: String,
    masterUserPassword: Option[SensitiveString] = None,
    preferredBackupWindow: Option[String] = None,
    preferredMaintenanceWindow: Option[String] = None,
    publiclyAccessible: Option[Boolean] = None,
    tags: Option[Iterable[zio.aws.lightsail.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest = {
    import CreateRelationalDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest
      .builder()
      .relationalDatabaseName(
        ResourceName.unwrap(relationalDatabaseName): java.lang.String
      )
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .relationalDatabaseBlueprintId(
        relationalDatabaseBlueprintId: java.lang.String
      )
      .relationalDatabaseBundleId(relationalDatabaseBundleId: java.lang.String)
      .masterDatabaseName(masterDatabaseName: java.lang.String)
      .masterUsername(masterUsername: java.lang.String)
      .optionallyWith(
        masterUserPassword.map(value =>
          SensitiveString.unwrap(value): java.lang.String
        )
      )(_.masterUserPassword)
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.CreateRelationalDatabaseRequest.ReadOnly =
    zio.aws.lightsail.model.CreateRelationalDatabaseRequest
      .wrap(buildAwsValue())
}
object CreateRelationalDatabaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateRelationalDatabaseRequest =
      zio.aws.lightsail.model.CreateRelationalDatabaseRequest(
        relationalDatabaseName,
        availabilityZone.map(value => value),
        relationalDatabaseBlueprintId,
        relationalDatabaseBundleId,
        masterDatabaseName,
        masterUsername,
        masterUserPassword.map(value => value),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        publiclyAccessible.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def relationalDatabaseName: ResourceName
    def availabilityZone: Option[String]
    def relationalDatabaseBlueprintId: String
    def relationalDatabaseBundleId: String
    def masterDatabaseName: String
    def masterUsername: String
    def masterUserPassword: Option[SensitiveString]
    def preferredBackupWindow: Option[String]
    def preferredMaintenanceWindow: Option[String]
    def publiclyAccessible: Option[Boolean]
    def tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def getRelationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseName)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getRelationalDatabaseBlueprintId: ZIO[Any, Nothing, String] =
      ZIO.succeed(relationalDatabaseBlueprintId)
    def getRelationalDatabaseBundleId: ZIO[Any, Nothing, String] =
      ZIO.succeed(relationalDatabaseBundleId)
    def getMasterDatabaseName: ZIO[Any, Nothing, String] =
      ZIO.succeed(masterDatabaseName)
    def getMasterUsername: ZIO[Any, Nothing, String] =
      ZIO.succeed(masterUsername)
    def getMasterUserPassword: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest
  ) extends zio.aws.lightsail.model.CreateRelationalDatabaseRequest.ReadOnly {
    override val relationalDatabaseName: ResourceName =
      zio.aws.lightsail.model.primitives
        .ResourceName(impl.relationalDatabaseName())
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val relationalDatabaseBlueprintId: String =
      impl.relationalDatabaseBlueprintId(): String
    override val relationalDatabaseBundleId: String =
      impl.relationalDatabaseBundleId(): String
    override val masterDatabaseName: String = impl.masterDatabaseName(): String
    override val masterUsername: String = impl.masterUsername(): String
    override val masterUserPassword: Option[SensitiveString] = scala
      .Option(impl.masterUserPassword())
      .map(value => zio.aws.lightsail.model.primitives.SensitiveString(value))
    override val preferredBackupWindow: Option[String] =
      scala.Option(impl.preferredBackupWindow()).map(value => value: String)
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val publiclyAccessible: Option[Boolean] =
      scala.Option(impl.publiclyAccessible()).map(value => value: Boolean)
    override val tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest
  ): zio.aws.lightsail.model.CreateRelationalDatabaseRequest.ReadOnly =
    new Wrapper(impl)
}
