package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteBucketAccessKeyResponse(
    operations: Option[Iterable[zio.aws.lightsail.model.Operation]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyResponse = {
    import DeleteBucketAccessKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyResponse
      .builder()
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operations)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.DeleteBucketAccessKeyResponse.ReadOnly =
    zio.aws.lightsail.model.DeleteBucketAccessKeyResponse.wrap(buildAwsValue())
}
object DeleteBucketAccessKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DeleteBucketAccessKeyResponse =
      zio.aws.lightsail.model.DeleteBucketAccessKeyResponse(
        operations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def operations: Option[List[zio.aws.lightsail.model.Operation.ReadOnly]]
    def getOperations
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Operation.ReadOnly]] =
      AwsError.unwrapOptionField("operations", operations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyResponse
  ) extends zio.aws.lightsail.model.DeleteBucketAccessKeyResponse.ReadOnly {
    override val operations
        : Option[List[zio.aws.lightsail.model.Operation.ReadOnly]] = scala
      .Option(impl.operations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.Operation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyResponse
  ): zio.aws.lightsail.model.DeleteBucketAccessKeyResponse.ReadOnly =
    new Wrapper(impl)
}
